package ru.yandex.autotests.directintapi.bstransport.main.canvasad.transmit;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import ru.yandex.autotests.direct.cmd.rules.CreativeBannerRule;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.campaigns.CampaignTypeEnum;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.displaycanvas.ModerationInfo;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pashkus on 08.09.16.
 * https://st.yandex-team.ru/TESTIRT-10191
 */

public abstract class SendingOfCanvasBannerBaseTest {
    public String LOGIN;

    protected LogSteps log = LogSteps.getLogger(this.getClass());
    public TransportHelpSteps helpSteps;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @ClassRule
    public static DirectCmdRule defaultClassRule = DirectCmdRule.defaultClassRule();

    public CreativeBannerRule bannersRule;

    @Rule
    public Trashman trashman = new Trashman(api);

    @Rule
    public DirectCmdRule cmdRule;

    protected static int shard;
    protected Long cid;
    protected Long pid;
    protected Long bid;
    protected Long creativeId;

    protected DirectJooqDbSteps jooqDbSteps;

    public CampaignTypeEnum campaignType;
    public AdGroupType adGroupType;
    public BannerType bannerType;

    public RunBsTransportScriptResponse resp;

    public SendingOfCanvasBannerBaseTest(CampaignTypeEnum campaignType, AdGroupType adGroupType, BannerType bannerType) {
        this.campaignType = campaignType;
        this.adGroupType = adGroupType;
        this.bannerType = bannerType;
        this.LOGIN = getLogin();
        api.as(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        jooqDbSteps =  api.userSteps.getDirectJooqDbSteps().useShard(shard);
        this.helpSteps = new TransportHelpSteps(api).useDbJooqSteps(jooqDbSteps);
        bannersRule = new CreativeBannerRule(campaignType).withUlogin(LOGIN);
        cmdRule = DirectCmdRule.defaultRule().withRules(bannersRule);
    }

    abstract void additionalInit();

    public String getLogin() {return Logins.LOGIN_TRANSPORT_IMG_AD;}
    
    @Before
    @Step("Подготовка: создаем баннер КК + substeps(optional)")
    public void basicInit() {                   //Todo: Важно! сделать однократный запуск before и подружить его с cmd-рулами
        cid = bannersRule.getCampaignId();
        creativeId = bannersRule.getCreativeId();
        bid = bannersRule.getBannerId();
        pid = bannersRule.getGroupId();

        assumeThat("у баннера есть хотя бы одна ключевая фраза",
                bannersRule.getCurrentGroup().getPhrases().size(),
                notNullValue());
        Long keywordId = bannersRule.getCurrentGroup().getPhrases().get(0).getId();

        additionalInit();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        jooqDbSteps.bannersPerformanceSteps()
                .setCreativeStatusModerate(cid, pid, bid, BannersPerformanceStatusmoderate.Yes);
        jooqDbSteps.perfCreativesSteps().setModerateInfo(creativeId,
                new ModerationInfo().generateTestData().asJson());

        resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
    }

}
