package ru.yandex.autotests.directintapi.bstransport.main.canvasad.transmit;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.campaigns.CampaignTypeEnum;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by pashkus on 08.09.16.
 * https://st.yandex-team.ru/TESTIRT-10191
 * + https://st.yandex-team.ru/TESTIRT-10837 (TemplateID)
 */

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Title("Транспорт: проверка отправки нового графического баннера в новой группе")
@Stories(StoriesNames.CANVAS_AD_SENDING)
@Features(FeatureNames.CANVAS_IMAGE_ADS)
@Issue("https://st.yandex-team.ru/DIRECT-57413")
@RunWith(Parameterized.class)
public class SendingOfCanvasBannerParamsTest extends SendingOfCanvasBannerBaseTest {

    @Parameterized.Parameters(name = "Тип кампаниии: {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {CampaignTypeEnum.TEXT, BannerType.TEXT},
                {CampaignTypeEnum.MOBILE, BannerType.MOBILE_CONTENT}
        };
        return Arrays.asList(data);
    }

    public SendingOfCanvasBannerParamsTest(CampaignTypeEnum campaignTypeEnum, BannerType bannerType) {
        super(campaignTypeEnum, AdGroupType.BASE, bannerType);
    }

    void additionalInit() {
    }

    @Test
    @Title("Проверяем, параметры креативного баннера, отправляемые в БК")
    public void testSendingToBs() {
        Campaign campaign
                = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner banner = context != null ? context.getBanner(bid) : null;
        assumeThat("в запросе есть креативный баннер", banner, notNullValue());

        Banner expectedCanvasBanner = helpSteps.buildExpectedNewCanvasBannerFromDb(bid);

        AllureUtils.addJsonAttachment("Ожидание:", expectedCanvasBanner.asJson());
        assertThat("параметры  креативного баннера соответсвуют ожиданиям",
                banner,
                beanDiffer(expectedCanvasBanner).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }

}
