package ru.yandex.autotests.directintapi.bstransport.main.canvasad.transmit.lang;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.CreativeBannerRule;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampOptionsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.campaigns.CampaignTypeEnum;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.displaycanvas.ModerationInfo;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.BannerLanguage;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.core.IsNull.notNullValue;
import static org.junit.Assume.assumeThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pashkus on 08.09.16.
 * https://st.yandex-team.ru/TESTIRT-10191
 */

@Aqua.Test
@Ignore   // wait for https://st.yandex-team.ru/DIRECT-58574
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Title("Проверяем настройку языка баннера на уровне кампании")
@Description("Язык баннера 'ru'; Меняем язык в camp_options.content_lang; Ожидаем что в БК отправится именно он")
@Stories(StoriesNames.CANVAS_AD_SENDING)
@Features(FeatureNames.CANVAS_IMAGE_ADS)
@Issue("https://st.yandex-team.ru/DIRECT-57413")
@RunWith(Parameterized.class)
public class SendingOfCanvasBannerLanguageSuperTest extends SendingOfCanvasBannerLanguageBaseTest {
    public static final String LOGIN = Logins.LOGIN_TRANSPORT_IMG_AD;

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @ClassRule
    public static DirectCmdRule defaultClassRule = DirectCmdRule.defaultClassRule();

    public CreativeBannerRule bannersRule;

    @Rule
    public Trashman trashman = new Trashman(api);

    @Rule
    public DirectCmdRule cmdRule;

    protected static int shard;
    protected Long cid;
    protected Long pid;
    protected Long bid;
    protected Long creativeId;

    public CampaignTypeEnum campaignType;
    public BannerLanguage bannerLanguage;
    private final BannerLanguage DEFAULT_BANNER_LANG = BannerLanguage.RUSSIAN;

    public RunBsTransportScriptResponse resp;

    public SendingOfCanvasBannerLanguageSuperTest(CampaignTypeEnum campaignType, BannerLanguage bannerLanguage) {
        this.campaignType = campaignType;
        this.bannerLanguage = bannerLanguage;
        bannersRule = new CreativeBannerRule(campaignType).withUlogin(LOGIN);
        cmdRule = DirectCmdRule.defaultRule().withRules(bannersRule);
    }

    @Parameterized.Parameters(name = "Тип кампаниии: {0}; язык баннера: {1}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {CampaignTypeEnum.TEXT, BannerLanguage.ENGLISH},
                {CampaignTypeEnum.TEXT, BannerLanguage.GERMAN},
                {CampaignTypeEnum.TEXT, BannerLanguage.TURKISH},
                {CampaignTypeEnum.TEXT, BannerLanguage.KAZAKH},
                {CampaignTypeEnum.TEXT, BannerLanguage.UKRAINIAN},
                {CampaignTypeEnum.TEXT, BannerLanguage.RUSSIAN},
                {CampaignTypeEnum.TEXT, BannerLanguage.BELARUSIAN},
                {CampaignTypeEnum.TEXT, BannerLanguage.UZBEK},
                {CampaignTypeEnum.MOBILE, BannerLanguage.ENGLISH},
                {CampaignTypeEnum.MOBILE, BannerLanguage.GERMAN},
                {CampaignTypeEnum.MOBILE, BannerLanguage.TURKISH},
                {CampaignTypeEnum.MOBILE, BannerLanguage.KAZAKH},
                {CampaignTypeEnum.MOBILE, BannerLanguage.UKRAINIAN},
                {CampaignTypeEnum.MOBILE, BannerLanguage.RUSSIAN},
                {CampaignTypeEnum.MOBILE, BannerLanguage.BELARUSIAN},
                {CampaignTypeEnum.MOBILE, BannerLanguage.UZBEK},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовка: создаем кампанию с креативным баннером. ")
    public void basicInit() {
        api.as(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        cid = bannersRule.getCampaignId();
        creativeId = bannersRule.getCreativeId();
        bid = bannersRule.getBannerId();
        pid = bannersRule.getGroupId();
        assumeThat("у баннера есть хотя бы одна ключевая фраза",
                bannersRule.getCurrentGroup().getPhrases().size(),
                notNullValue());
        Long keywordId = bannersRule.getCurrentGroup().getPhrases().get(0).getId();

        CampOptionsRecord campOptions = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN).campaignsSteps().getCampOptionsById(cid);
        campOptions.setContentLang(bannerLanguage.dbValue());
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN).campaignsSteps().updateCampOptions(campOptions);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        jooqDbSteps.bannersPerformanceSteps()
                .setCreativeStatusModerate(cid, pid, bid, BannersPerformanceStatusmoderate.Yes);
        jooqDbSteps.perfCreativesSteps().setModerateInfo(creativeId,
                new ModerationInfo().generateTestData(DEFAULT_BANNER_LANG).asJson());

        BannersRecord bannersRecord = jooqDbSteps.bannersSteps().getBanner(bid);
        bannersRecord.setLanguage(convertLanguage(DEFAULT_BANNER_LANG.dbValue()));
        jooqDbSteps.bannersSteps().updateBanners(bannersRecord);

        resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
    }

    @Test
    @Title("Проверяем переопределения языка баннера на уровне кампании")
    @Description("Ожидаем, что в Banner.Lang отправится значение из camp_options.content_lang")
    public void testSendingToBs() {
        Campaign campaign
                = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner banner = context != null ? context.getBanner(bid) : null;

        assertThat("Banner.Lang соответсвует ожиданиям", banner.getLang(), equalTo(bannerLanguage.transportValue()));
    }

}
