package ru.yandex.autotests.directintapi.bstransport.main.contentpromotion.queue.common;

import java.util.Arrays;
import java.util.Map;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupsContentPromotionContentPromotionType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BidsStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasItem;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Транспорт: проверка отправки в БК нового баннера продвижения контента в новой группе")
@Stories(StoriesNames.CONTENT_PROMOTION_CREATION)
@Features({FeatureNames.CONTENT_PROMOTION, FeatureNames.NOT_FOR_FULL_EXPORT})
@Issue("https://st.yandex-team.ru/DIRECT-100218")
public class BsTransportNewContentPromotionAddToQueueTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static int shard;
    private Long cid;
    private Long pid;
    private Long bid;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.getDirectJooqDbSteps().shardingSteps().getShardByLogin(LOGIN);
    }

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        cid = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap().defaultCampaignAddItem()
                        .withTextCampaign(new TextCampaignAddItemMap().defaultTextCampaign()
                                .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                        .withNetwork(new TextCampaignNetworkStrategyAddMap().defaultServingOff())
                                        .withSearch(new TextCampaignSearchStrategyAddMap().defaultHighestPosition()))));
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long phraseId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShard(shard).bidsSteps()
                .setBidsStatusModerate(phraseId,
                        BidsStatusmoderate.Yes);

        api.userSteps.campaignFakeSteps().setType(cid, CampaignsType.CONTENT_PROMOTION);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps()
                .setType(pid, PhrasesAdgroupType.content_promotion);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps()
                .setBannersBannerType(bid, BannersBannerType.content_promotion);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsContentPromotionSteps()
                .addAdGroupContentPromotion(pid, AdgroupsContentPromotionContentPromotionType.collection);
    }

    @Test
    public void testAddingToBsQueue() {
        api.userSteps.transportSteps().runBsExportMasterScript(shard, cid);
        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().runBsClientDataScript(shard, cid);

        Map campaign = api.userSteps.transportSteps().getRawClientDataLogRequestForCampaign(resp, cid);
        Map context = api.userSteps.transportSteps().getRawClientDataLogRequestForContext(resp, cid, pid);
        Map banner = api.userSteps.transportSteps().getRawClientDataLogRequestForBanner(resp, cid, pid, bid);
        Map keyword = api.userSteps.transportSteps().getRawClientDataLogRequestForKeyword(resp, cid, pid);

        assertThat("Ожидаем, что в БК была отправлена новая кампания", campaign, notNullValue());
        assertThat("Ожидаем, что в БК была отправлена новая группа", context, notNullValue());
        assertThat("Ожидаем, что в БК был отправлен новый баннер", banner, notNullValue());
        assertThat("Ожидаем, что в БК была отправлена новая фраза", keyword, notNullValue());
    }

    @Test
    public void testAddingTwoToBsQueue() {
        api.userSteps.campaignFakeSteps().setType(cid, CampaignsType.TEXT);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps()
                .setType(pid, PhrasesAdgroupType.base);
        Long bidNew = api.userSteps.adsSteps().addDefaultTextAd(pid);
        api.userSteps.campaignFakeSteps().setType(cid, CampaignsType.CONTENT_PROMOTION);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps()
                .setType(pid, PhrasesAdgroupType.content_promotion);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps()
                .setBannersBannerType(bidNew, BannersBannerType.content_promotion);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidNew);
        long phraseNewId = api.userSteps.phrasesFakeSteps().getPhraseIdsByPid(pid)[0];
        api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShard(shard).bidsSteps()
                .setBidsStatusModerate(phraseNewId,
                        BidsStatusmoderate.Yes);

        api.userSteps.transportSteps().runBsExportMasterScript(shard, cid);
        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().runBsClientDataScript(shard, cid);

        Map campaign = api.userSteps.transportSteps().getRawClientDataLogRequestForCampaign(resp, cid);
        Map context = api.userSteps.transportSteps().getRawClientDataLogRequestForContext(resp, cid, pid);
        Map banner = api.userSteps.transportSteps().getRawClientDataLogRequestForBanner(resp, cid, pid, bid);
        Map bannerNew = api.userSteps.transportSteps().getRawClientDataLogRequestForBanner(resp, cid, pid, bidNew);
        Map keyword = api.userSteps.transportSteps().getRawClientDataLogRequestForKeyword(resp, cid, pid);

        assertThat("Ожидаем, что в БК была отправлена новая кампания", campaign, notNullValue());
        assertThat("Ожидаем, что в БК была отправлена новая группа", context, notNullValue());
        assertThat("Ожидаем, что в БК были отправлены новые баннеры", Arrays.asList(banner, bannerNew),
                not(hasItem(nullValue())));
        assertThat("Ожидаем, что в БК была отправлена новая фраза", keyword, notNullValue());
    }
}
