package ru.yandex.autotests.directintapi.bstransport.main.contentpromotion.queue.service;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.TextBannersRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupsContentPromotionContentPromotionType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BidsStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.setBannerStatuses;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Транспорт: проверка отправки в БК content_promotion кампании Услуг")
@Features({FeatureNames.CONTENT_PROMOTION, FeatureNames.NOT_FOR_FULL_EXPORT})
@Issue("https://st.yandex-team.ru/DIRECT-108662")
@RunWith(Parameterized.class)
public class BsTransportNewContentPromotionServiceAddToQueueStatusModerateTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static final DirectCmdRule defaultClassRule = DirectCmdRule.defaultClassRule();

    public static final TextBannersRule bannersRule = new TextBannersRule().withUlogin(LOGIN);

    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().withRules(bannersRule);

    private static int shard;
    private Long cid;
    private Long bid;
    private Long pid;

    @Parameterized.Parameter()
    public String bannerStatus;
    @Parameterized.Parameter(1)
    public BidsStatusmoderate bidsStatusmoderate;
    @Parameterized.Parameter(2)
    public boolean expectCampaign;
    @Parameterized.Parameter(3)
    public boolean expectContext;

    @Parameterized.Parameters(name = "статус модерации баннера: {0}, " +
            "статус модерации ключевой фразы: {1}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {Status.NEW, BidsStatusmoderate.New, true, false},
                {Status.NEW, BidsStatusmoderate.No, true, false},
                {Status.NEW, BidsStatusmoderate.Yes, true, false},

                {Status.SENDING, BidsStatusmoderate.New, true, false},
                {Status.SENDING, BidsStatusmoderate.No, true, false},
                {Status.SENDING, BidsStatusmoderate.Yes, true, false},

                {Status.SENT, BidsStatusmoderate.New, true, false},
                {Status.SENT, BidsStatusmoderate.No, true, false},
                {Status.SENT, BidsStatusmoderate.Yes, true, false},

                {Status.NO, BidsStatusmoderate.New, false, false},
                {Status.NO, BidsStatusmoderate.No, false, false},
                {Status.NO, BidsStatusmoderate.Yes, false, false},

                {Status.YES, BidsStatusmoderate.New, true, false},
                {Status.YES, BidsStatusmoderate.No, true, false},
                {Status.YES, BidsStatusmoderate.Yes, true, true},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.getDirectJooqDbSteps().shardingSteps().getShardByLogin(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        cid = bannersRule.getCampaignId();
        bid = bannersRule.getBannerId();
        pid = bannersRule.getGroupId();

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        setBannerStatuses(api, bid, bannerStatus, bannerStatus, cid);

        Long phraseId = api.userSteps.phrasesFakeSteps().getPhraseIdsByPid(pid)[0];
        api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShard(shard).bidsSteps()
                .setBidsStatusModerate(phraseId,
                        bidsStatusmoderate);

        api.userSteps.campaignFakeSteps().setType(cid, CampaignsType.CONTENT_PROMOTION);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps()
                .setType(pid, PhrasesAdgroupType.content_promotion);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps()
                .setBannersBannerType(bid, BannersBannerType.content_promotion);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsContentPromotionSteps()
                .addAdGroupContentPromotion(pid, AdgroupsContentPromotionContentPromotionType.service);

    }

    @Test
    public void testAddingToBsQueue() {

        api.userSteps.transportSteps().runBsExportMasterScript(shard, cid);
        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().runBsClientDataScript(shard, cid);
        if (!expectCampaign) {
            assertThat("Кампания не была отправлена в БК", resp, nullValue());
            return;
        }

        Map campaign = api.userSteps.transportSteps().getRawClientDataLogRequestForCampaign(resp, cid);
        Map context = api.userSteps.transportSteps().getRawClientDataLogRequestForContext(resp, cid, pid);
        Map banner = api.userSteps.transportSteps().getRawClientDataLogRequestForBanner(resp, cid, pid, bid);
        Map keyword = api.userSteps.transportSteps().getRawClientDataLogRequestForKeyword(resp, cid, pid);

        assertThat("Ожидаем, что в БК была отправлена новая кампания", campaign, notNullValue());
        if (expectContext) {
            assertThat("Ожидаем, что в БК была отправлена новая группа", context, notNullValue());
            assertThat("Ожидаем, что в БК был отправлен новый баннер", banner, notNullValue());
            assertThat("Ожидаем, что в БК была отправлена новая фраза", keyword, notNullValue());
        } else {
            assertThat("Ожидаем, что в БК не была отправлена новая группа", context, nullValue());
        }
    }
}
