package ru.yandex.autotests.directintapi.bstransport.main.contentpromotion.transmit.common;

import java.util.List;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.BannersRule;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.TextBannersRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupsContentPromotionContentPromotionType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsPlatform;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.irt.testutils.allure.TestSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.nullValue;
import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.directapi.darkside.model.bslogs.BannerTemplateId.PPC_TEMPLATE_ID;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Description("Проверяем отправку общих полей, имеющих определенное значение при отправке content_promotion кампании")
@Features(FeatureNames.CONTENT_PROMOTION)
@Issue("https://st.yandex-team.ru/DIRECT-100218")
public class SendingContentPromotionCommonFields {

    private static final String LOGIN = Logins.CHECK_GOALS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static DirectCmdRule defaultClassRule = DirectCmdRule.defaultClassRule();

    public BannersRule bannersRule = new TextBannersRule().withUlogin(LOGIN);

    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().withRules(bannersRule);

    private static int shard;
    private Long pid;
    private Long bid;
    private Campaign campaign;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.getDirectJooqDbSteps().shardingSteps().getShardByLogin(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        Long cid = bannersRule.getCampaignId();
        bid = bannersRule.getBannerId();
        pid = bannersRule.getGroupId();
        Long keywordId = bannersRule.getCurrentGroup().getPhrases().get(0).getId();

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);

        jooqDbSteps.campaignsSteps().setPlatform(cid, CampaignsPlatform.search);
        jooqDbSteps.campaignsSteps().setType(cid, CampaignsType.content_promotion);
        jooqDbSteps.adGroupsSteps().setType(pid, PhrasesAdgroupType.content_promotion);
        jooqDbSteps.bannersSteps().setBannersBannerType(bid, BannersBannerType.content_promotion);
        jooqDbSteps.adGroupsContentPromotionSteps().addAdGroupContentPromotion(pid,
                AdgroupsContentPromotionContentPromotionType.collection);

        RunBsTransportScriptResponse resp
                = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
    }

    @Test
    public void testContentType() {
        assertThat("передан правильный Order->{ContentType}", campaign.getContentType(),
                equalTo(CampaignsType.text.getLiteral()));
    }

    @Test
    public void testContextType() {
        Context context = campaign != null ? campaign.getContext(pid) : null;
        TestSteps.assumeThat("в запросе есть группа", context, notNullValue());
        assertThat("передан правильный Context->{Type}", context.getType(),
                equalTo(PhrasesAdgroupType.base.getLiteral()));
    }

    @Test
    public void testTargetType() {
        assertThat("передан правильный TargetType",
                campaign.getShowCondition().getTargetType(), equalTo(singletonList(3)));
    }

    @Test
    public void testTags() {
        List<String> tags = singletonList("content-promotion-collection");
        Context context = campaign.getContext(pid);
        assertThat("переданы правильные Target-теги", context.getTargetTags(), is(tags));
        assertThat("переданы правильные PageGroup-теги", context.getPageGroupTags(), is(tags));
    }

    @Test
    public void testHrefHrefText() {
        Banner banner = campaign.getContext(pid).getBanner(bid);
        assertThat("передан правильный Href", banner.getHref(), is("http://ya.ru"));
        assertThat("передан правильный HrefText", banner.getHrefText(), nullValue());
    }

    @Test
    public void testTemplateId() {
        Banner banner = campaign.getContext(pid).getBanner(bid);
        assertThat("передан TemplateID", banner.getTemplateId(), is(PPC_TEMPLATE_ID.value()));
    }
}
