package ru.yandex.autotests.directintapi.bstransport.main.contentpromotion.transmit.common;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.TextBannersRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupsContentPromotionContentPromotionType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusactive;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BidsStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsPlatform;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.nullValue;
import static org.junit.Assert.assertThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Транспорт: проверка транспорта кликовой ссылки для content_promotion кампании")
@Features({FeatureNames.CONTENT_PROMOTION, FeatureNames.NOT_FOR_FULL_EXPORT})
@Issue("https://st.yandex-team.ru/DIRECT-100218")
public class SendingContentPromotionVisitHrefTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    private static final String METADATA_JSON = "{\"Title\": \"old title\", \"Passage\": \"старое описание\"}";
    private static final String VISIT_HREF = "https://www.yandex.ru/";
    private static final String VISIT_HREF2 = "https://www.google.ru/";

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static final DirectCmdRule defaultClassRule = DirectCmdRule.defaultClassRule();

    public static final TextBannersRule bannersRule = new TextBannersRule().withUlogin(LOGIN);

    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().withRules(bannersRule);

    private static int shard;
    private Long clientId;
    private Long cid;
    private Long pid;
    private Long bid;
    private Long bid2;
    private Long cpid;
    private static DirectJooqDbSteps jooq;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.getDirectJooqDbSteps().shardingSteps().getShardByLogin(LOGIN);
        jooq = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        cid = bannersRule.getCampaignId();
        bid = bannersRule.getBannerId();
        pid = bannersRule.getGroupId();
        clientId = jooq.shardingSteps().getClientIdByLogin(LOGIN);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        jooq.bannersSteps().setBannerStatusActive(bid, BannersStatusactive.Yes);

        Long bidId = jooq.bidsSteps().getBidsByPid(pid).get(0).getId();
        jooq.bidsSteps().setBidsStatusModerate(bidId, BidsStatusmoderate.Yes);

        jooq.campaignsSteps().setPlatform(cid, CampaignsPlatform.search);

        jooq.campaignsSteps().setType(cid, CampaignsType.content_promotion);
        jooq.adGroupsSteps().setType(pid, PhrasesAdgroupType.content_promotion);
        jooq.bannersSteps().setBannersBannerType(bid, BannersBannerType.content_promotion);
        cpid = jooq.contentPromotionSteps().addDefaultContentPromotion(clientId, METADATA_JSON);
        jooq.contentPromotionSteps().addContentPromotionToBanner(bid, cpid, VISIT_HREF);
        jooq.adGroupsContentPromotionSteps().addAdGroupContentPromotion(pid,
                AdgroupsContentPromotionContentPromotionType.collection);
    }

    @Test
    public void oneBannerWithVisitHrefTest() {
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps()
                .sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, cid);

        String actualVisitHref = campaign.getContext(pid).getBanner(bid).getResources().getVisitHref();

        assertThat(actualVisitHref, is(VISIT_HREF));
    }

    @Test
    public void oneBannerWithoutVisitHrefTest() {
        api.userSteps.getDirectJooqDbSteps().useShard(shard).contentPromotionSteps()
                .addContentPromotionToBanner(bid, cpid, null);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps()
                .sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, cid);

        String actualVisitHref = campaign.getContext(pid).getBanner(bid).getResources().getVisitHref();

        assertThat(actualVisitHref, is(nullValue()));
    }

    @Test
    public void twoBannersWithDifferentMetadataTest() {
        jooq.campaignsSteps().setType(cid, CampaignsType.text);
        jooq.adGroupsSteps().setType(pid, PhrasesAdgroupType.base);

        bid2 = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long cp2id = jooq.contentPromotionSteps().addDefaultContentPromotion(clientId, METADATA_JSON);
        jooq.contentPromotionSteps().addContentPromotionToBanner(bid2, cp2id, VISIT_HREF2);

        prepareCampaignForSending();

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps()
                .sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, cid);

        String actualVisitHref1 = campaign.getContext(pid).getBanner(bid).getResources().getVisitHref();
        assertThat(actualVisitHref1, is(VISIT_HREF));

        String actualVisitHref2 = campaign.getContext(pid).getBanner(bid2).getResources().getVisitHref();
        assertThat(actualVisitHref2, is(VISIT_HREF2));
    }

    private void prepareCampaignForSending() {
        jooq.campaignsSteps().setType(cid, CampaignsType.content_promotion);
        jooq.adGroupsSteps().setType(pid, PhrasesAdgroupType.content_promotion);
        jooq.bannersSteps().setBannersBannerType(bid2, BannersBannerType.content_promotion);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid2);
        Long bidId = jooq.bidsSteps().getBidsByPid(pid).get(0).getId();
        jooq.bidsSteps().setBidsStatusModerate(bidId, BidsStatusmoderate.Yes);
    }
}
