package ru.yandex.autotests.directintapi.bstransport.main.contentpromotion.transmit.service;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.TextBannersRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupsContentPromotionContentPromotionType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusactive;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BidsStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsPlatform;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Транспорт: проверка транспорта полей transport и href для content_promotion кампании Услуг")
@Features({FeatureNames.CONTENT_PROMOTION, FeatureNames.NOT_FOR_FULL_EXPORT})
@Issue("https://st.yandex-team.ru/DIRECT-108662")
public class SendingContentPromotionServiceTitleBodyTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    private static final String METADATA_JSON = "{\"service_url\": \"https://old-service-url.ru\"}";
    private static final String TITLE = "Services Title";
    private static final String TITLE_2 = "Services Title 2";

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static final DirectCmdRule defaultClassRule = DirectCmdRule.defaultClassRule();

    public static final TextBannersRule bannersRule = new TextBannersRule().withUlogin(LOGIN);

    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().withRules(bannersRule);

    private static int shard;
    private Long clientId;
    private Long cid;
    private Long pid;
    private Long bid;
    private Long bid2;
    private Long cpid;

    private static DirectJooqDbSteps jooq;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.getDirectJooqDbSteps().shardingSteps().getShardByLogin(LOGIN);
        jooq = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        cid = bannersRule.getCampaignId();
        bid = bannersRule.getBannerId();
        pid = bannersRule.getGroupId();
        clientId = jooq.shardingSteps().getClientIdByLogin(LOGIN);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        jooq.bannersSteps().setBannerStatusActive(bid, BannersStatusactive.Yes);

        Long bidId = jooq.bidsSteps().getBidsByPid(pid).get(0).getId();
        jooq.bidsSteps().setBidsStatusModerate(bidId, BidsStatusmoderate.Yes);

        jooq.campaignsSteps().setPlatform(cid, CampaignsPlatform.search);

        jooq.campaignsSteps().setType(cid, CampaignsType.content_promotion);
        jooq.adGroupsSteps().setType(pid, PhrasesAdgroupType.content_promotion);
        jooq.bannersSteps().setBannersBannerType(bid, BannersBannerType.content_promotion);
        cpid = jooq.contentPromotionSteps().addDefaultContentPromotion(clientId, METADATA_JSON);
        jooq.contentPromotionSteps().addContentPromotionToBanner(bid, cpid);
        jooq.adGroupsContentPromotionSteps().addAdGroupContentPromotion(pid,
                AdgroupsContentPromotionContentPromotionType.service);

        jooq.bannersSteps().setBannersTitle(bid, TITLE);
    }

    @Test
    public void oneBannerWithTitleTest() {
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps()
                .sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, cid);

        String actualBannerTitle = campaign.getContext(pid).getBanner(bid).getTitle();
        assertThat(actualBannerTitle, is(TITLE));

        String actualBannerBody = campaign.getContext(pid).getBanner(bid).getBody();
        assertThat(actualBannerBody, is(TITLE));
    }

    @Test
    public void twoBannersWithDifferentTitlesTest() {
        jooq.campaignsSteps().setType(cid, CampaignsType.text);
        jooq.adGroupsSteps().setType(pid, PhrasesAdgroupType.base);

        bid2 = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long cp2id = jooq.contentPromotionSteps().addDefaultContentPromotion(clientId, METADATA_JSON);
        jooq.contentPromotionSteps().addContentPromotionToBanner(bid2, cp2id);
        jooq.bannersSteps().setBannersTitle(bid2, TITLE_2);

        prepareCampaignForSending();

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps()
                .sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, cid);

        String actualBannerTitle = campaign.getContext(pid).getBanner(bid).getTitle();
        assertThat(actualBannerTitle, is(TITLE));

        String actualBannerBody = campaign.getContext(pid).getBanner(bid).getBody();
        assertThat(actualBannerBody, is(TITLE));

        String actualBannerTitle2 = campaign.getContext(pid).getBanner(bid2).getTitle();
        assertThat(actualBannerTitle2, is(TITLE_2));

        String actualBannerBody2 = campaign.getContext(pid).getBanner(bid2).getBody();
        assertThat(actualBannerBody2, is(TITLE_2));
    }

    @Test
    public void oneBannerWithNullTitleTest() {
        cpid = jooq.contentPromotionSteps().addDefaultContentPromotion(clientId, METADATA_JSON);
        jooq.contentPromotionSteps().addContentPromotionToBanner(bid, cpid);
        jooq.bannersSteps().setBannersTitle(bid, null);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps()
                .sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, cid);

        String actualBannerTitle = campaign.getContext(pid).getBanner(bid).getTitle();
        String actualBannerBody = campaign.getContext(pid).getBanner(bid).getBody();

        assertThat(actualBannerTitle, is("service"));
        assertThat(actualBannerBody, is("service"));
    }

    private void prepareCampaignForSending() {
        jooq.campaignsSteps().setType(cid, CampaignsType.content_promotion);
        jooq.adGroupsSteps().setType(pid, PhrasesAdgroupType.content_promotion);
        jooq.bannersSteps().setBannersBannerType(bid2, BannersBannerType.content_promotion);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid2);
        Long bidId = jooq.bidsSteps().getBidsByPid(pid).get(0).getId();
        jooq.bidsSteps().setBidsStatusModerate(bidId, BidsStatusmoderate.Yes);
    }
}
