package ru.yandex.autotests.directintapi.bstransport.main.cpmbanner.transmit;

import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.CreativeBannerRule;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.db.beans.campaign.StrategyData;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsAutobudget;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsPlatform;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStrategyName;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PerfCreativesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.StrategiesType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.StrategiesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.campaigns.CampaignTypeEnum;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.displaycanvas.ModerationInfo;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.directintapi.bstransport.TransportUtils.TRANSPORT_DATE_TIME_FORMATTER;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Description("Проверяем отправку бюджета и границ периода в зависимости от "
        + "расположения периода относительно сегодняшней даты")
@Features(FeatureNames.CPM_BANNER)
@Issue("https://st.yandex-team.ru/DIRECT-72162")
@RunWith(Parameterized.class)
public class SendingCpmStrategiesWithCustomPeriodInDifferentDatesTest {

    public static final String LOGIN = Logins.LOGIN_TRANSPORT_IMG_AD;
    private static final Money AVG_CPM = MoneyCurrency.get(Currency.RUB).getMinCpmPrice();
    private static final Money BUDGET =
            MoneyCurrency.get(Currency.RUB).getMaxWeeklyBudgetAmount().divide(10f);

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @ClassRule
    public static DirectCmdRule defaultClassRule = DirectCmdRule.defaultClassRule();

    public CreativeBannerRule bannersRule;

    @Rule
    public Trashman trashman = new Trashman(api);

    @Rule
    public DirectCmdRule cmdRule;

    public TransportHelpSteps helpSteps;

    protected static int shard;
    protected Long cid;

    public LocalDate start;
    public LocalDate finish;

    public RunBsTransportScriptResponse resp;

    public SendingCpmStrategiesWithCustomPeriodInDifferentDatesTest(LocalDate start, LocalDate finish) {
        this.start = start;
        this.finish = finish;
        bannersRule = new CreativeBannerRule(CampaignTypeEnum.TEXT).withUlogin(LOGIN);
        cmdRule = DirectCmdRule.defaultRule().withRules(bannersRule);
    }

    @Parameterized.Parameters(name = "start = {0}, finish = {1}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {LocalDate.now().minusDays(2), LocalDate.now().plusDays(2)},
                {LocalDate.now().plusDays(2), LocalDate.now().plusDays(4)},
                {LocalDate.now().minusDays(4), LocalDate.now().minusDays(2)},
                {LocalDate.now(), LocalDate.now().plusDays(2)},
                {LocalDate.now().minusDays(2), LocalDate.now()},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка: создаем кампанию с креативным баннером.")
    public void basicInit() {
        cid = bannersRule.getCampaignId();
        Long creativeId = bannersRule.getCreativeId();
        Long bid = bannersRule.getBannerId();
        Long pid = bannersRule.getGroupId();
        Long keywordId = bannersRule.getCurrentGroup().getPhrases().get(0).getId();

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        helpSteps = new TransportHelpSteps(api).useDbJooqSteps(jooqDbSteps);
        jooqDbSteps.bannersPerformanceSteps()
                .setCreativeStatusModerate(cid, pid, bid, BannersPerformanceStatusmoderate.Yes);
        jooqDbSteps.perfCreativesSteps().setModerateInfo(creativeId,
                new ModerationInfo().generateTestData().toString());
        jooqDbSteps.perfCreativesSteps().setStatusModerate(creativeId, PerfCreativesStatusmoderate.Yes);
        api.userSteps.campaignStepsV5().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(cid)
                                .withTextCampaign(new TextCampaignUpdateItemMap()
                                        .withBiddingStrategy(new TextCampaignStrategyMap()
                                                .withSearch(new TextCampaignSearchStrategyMap().defaultServingOff())
                                                .withNetwork(new TextCampaignNetworkStrategyMap().defaultMaximumCoverage())))),
                ExpectedResult.success());
        CampaignsRecord campaignsRecord = jooqDbSteps.campaignsSteps().getCampaignById(cid);
        campaignsRecord.setStrategyName(CampaignsStrategyName.autobudget_max_reach_custom_period);
        campaignsRecord.setPlatform(CampaignsPlatform.context);
        StrategyData strategyData = new StrategyData()
                .withName(CampaignsStrategyName.autobudget_max_reach_custom_period)
                .withBudget(BUDGET.doubleValue())
                .withAvgCpm(AVG_CPM.doubleValue())
                .withStart(start.toString())
                .withFinish(finish.toString())
                .withAutoProlongation(0);
        campaignsRecord.setStrategyData(strategyData.toJsonElement());
        campaignsRecord.setAutobudget(CampaignsAutobudget.Yes);
        jooqDbSteps.campaignsSteps().updateCampaigns(campaignsRecord);

        Long strategyId =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(cid).getStrategyId();
        if (strategyId != 0) {
            StrategiesRecord strategiesRecord =
                    api.userSteps.getDirectJooqDbSteps().useShard(shard).strategiesSteps().getStrategiesRecord(strategyId);
            strategiesRecord.setType(StrategiesType.autobudget_max_reach_custom_period);
            strategiesRecord.setStrategyData(strategyData.toJsonElement().toString());
            api.userSteps.getDirectJooqDbSteps().useShard(shard).strategiesSteps().updateStrategies(strategiesRecord);
        }

        resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
    }


    @Test
    public void testSendingToBs() {
        Campaign campaign
                = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        assumeThat("в запросе есть кампания", campaign, notNullValue());
        Campaign expectedCampaign = helpSteps.buildExpectedCampaignObjFromDb(cid, shard, UpdateInfo.UPDATE);
        expectedCampaign.setAutoBudgetPeriodBudgetLimitCur(BUDGET.addVAT()
                .setScale(Campaign.PRECISION_DIGIT_COUNT_RUB, RoundingMode.HALF_UP)
                .floatValue());
        // здесь можно было бы также проверить значение AutoBudgetPeriodBudgetLimit,
        // но вычисление этого поля не пережило переход на НДС 20%, и теперь оно вычисляется неправильно.
        // Это сознательно решили не исправлять, см. https://st.yandex-team.ru/DIRECT-88492
        expectedCampaign.setStartTime(start.atStartOfDay().format(TRANSPORT_DATE_TIME_FORMATTER));
        expectedCampaign.setAutoBudgetPeriodBudgetFinish(
                LocalDateTime.of(finish, LocalTime.MAX).format(TRANSPORT_DATE_TIME_FORMATTER));
        assertThat("параметры стратегии соответсвуют ожиданиям",
                campaign,
                helpSteps.campaignReq1Matcher(expectedCampaign));
    }
}
