package ru.yandex.autotests.directintapi.bstransport.main.cpmbanner.transmit;

import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatuspostmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PerfCreativesStatusmoderate;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.displaycanvas.ModerationInfo;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.steps.TransportSteps;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.is;
import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Description("Проверяем отправку stop для баннера со статусом креатива AdminReject")
@Features(FeatureNames.CPM_BANNER)
@Issue("https://st.yandex-team.ru/DIRECT-105823")
public class SendingCreativeAdminRejectedStopTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static int shard;
    @Rule
    public Trashman trashman = new Trashman(api);
    private Long cid;
    private Long pid;
    private Long bid;
    private DirectJooqDbSteps jooqDbSteps;
    private Long creativeId;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @After
    @Step("Чистка креативов")
    public void tearDown() {
        if (creativeId != null) {
            api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersPerformanceSteps()
                    .deleteBannersPerformanceRecord(creativeId);
            api.userSteps.getDirectJooqDbSteps().useShard(shard).perfCreativesSteps().deletePerfCreatives(creativeId);
        }
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        long clientId = Long.parseLong(api.userSteps.clientFakeSteps().getClientData(LOGIN).getClientID());
        creativeId = jooqDbSteps.perfCreativesSteps().saveDefaultCanvasCreativesForClient(clientId);
        cid = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultCpmBannerKeywordsAdGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultCpmBannerAdBuilderAd(pid, creativeId);
        api.userSteps.keywordsSteps().addDefaultKeywords(pid, 1);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().setPhraseStatusModerateYes(pid);
        jooqDbSteps.bannersPerformanceSteps()
                .setCreativeStatusModerate(cid, pid, bid, BannersPerformanceStatusmoderate.Yes);
        jooqDbSteps.perfCreativesSteps().setModerateInfo(creativeId,
                new ModerationInfo().generateTestData().toString());

        RunBsTransportScriptResponse sendNewCampaign = api.userSteps.getDarkSideSteps().getTransportSteps()
                .sendNewCampaign(shard, cid);
        Banner banner = checkResult(sendNewCampaign, 1);
        assumeThat("Баннер должен уйти в БК со stop = 0", banner.getStop(), is(0));
    }

    @Test
    public void testSendingValidAdminRejectedBanner() {
        sendAdminRejectToBs();
    }

    @Test
    public void testSendingOfBanner_StatusPostModerateNo_shouldSendStop() {
        jooqDbSteps.bannersSteps().setBannerStatusPostModerate(bid, BannersStatuspostmoderate.No);
        sendAdminRejectToBs();
    }

    @Test
    public void testSendingOfBanner_StatusModerateNo_shouldSendStop() {
        jooqDbSteps.bannersSteps().setBannerStatusModerate(bid, BannersStatusmoderate.No);
        sendAdminRejectToBs();
    }

    @Test
    public void testSendingOfBanner_BannersPerformanceModerateNo_shouldSendStop() {
        jooqDbSteps.bannersPerformanceSteps()
                .setCreativeStatusModerate(cid, pid, bid, BannersPerformanceStatusmoderate.No);
        sendAdminRejectToBs();
    }

    private Banner checkResult(RunBsTransportScriptResponse response, int iteration) {
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getClientDataRequestCampaign(response, iteration, cid);
        Banner banner = TransportSteps.getBsClientDataBanner(campaign, pid, bid);
        assumeThat("Баннер должен отправиться в БК", banner, notNullValue());
        return banner;
    }

    private void sendAdminRejectToBs() {
        jooqDbSteps.perfCreativesSteps().setStatusModerate(creativeId, PerfCreativesStatusmoderate.AdminReject);
        api.userSteps.bannersFakeSteps().setStatusBsSynced(bid, Status.NO);
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps()
                .sendSyncedCampaign(shard, cid);
        Banner banner = checkResult(resp, 0);
        assertThat("Баннер с AdminReject должен уйти в БК со stop = 1", banner.getStop(), is(1));
    }
}
