package ru.yandex.autotests.directintapi.bstransport.main.cpmbanner.transmit;

import java.util.Arrays;
import java.util.List;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerTypeMultiplierValuesBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.InventoryMultiplierValuesInventoryType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerTypeMultiplierValuesRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.InventoryMultiplierValuesRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Description("Проверяем корректировку по типу инвентаря в БК")
@Features(FeatureNames.CPM_BANNER)
@Issue("https://st.yandex-team.ru/DIRECT-86348")
public class SendingInventoryBidModifierTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long cid;
    private static int shard;

    static private Short MULTIPLIER_PCT1 = 200;
    static private Short MULTIPLIER_PCT2 = 500;
    static private Short MULTIPLIER_PCT3 = 75;
    static private Short MULTIPLIER_PCT4 = 10;

    @BeforeClass
    public static void configTestClass() {
        shard = api.userSteps.getDarkSideSteps().getClientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        cid = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign();
    }

    @Test
    public void checkBannerTypeCoef_CpmBannerOnly() {
        BannerTypeMultiplierValuesRecord multiplier = new BannerTypeMultiplierValuesRecord()
                .setBannerType(BannerTypeMultiplierValuesBannerType.cpm_banner)
                .setMultiplierPct(MULTIPLIER_PCT1);

        saveBannerTypeMultipliers(singletonList(multiplier));

        Campaign campaign = sendMultiplierToBsAndGetResultCampaign();

        assumeThat("в БК отправлена кампания", campaign, notNullValue());
        assumeThat("Значение BannerType соответствует ожидаемому значению", campaign.getProductTypeCoef().getBannerType(), equalTo(MULTIPLIER_PCT1));
    }

    @Test
    public void checkBannerTypeCoef_CpmVideoOnly() {
        BannerTypeMultiplierValuesRecord multiplier = new BannerTypeMultiplierValuesRecord()
                .setBannerType(BannerTypeMultiplierValuesBannerType.cpm_video)
                .setMultiplierPct(MULTIPLIER_PCT1);

        saveBannerTypeMultipliers(singletonList(multiplier));

        Campaign campaign = sendMultiplierToBsAndGetResultCampaign();

        assumeThat("в БК отправлена кампания", campaign, notNullValue());
        assumeThat("Значение InPage соответствует ожидаемому значению", campaign.getInventoryTypeCoef().getInpage(), equalTo(MULTIPLIER_PCT1));
        assumeThat("Значение InStream соответствует ожидаемому значению", campaign.getInventoryTypeCoef().getInstream_web(), equalTo(MULTIPLIER_PCT1));
        assumeThat("Значение InApp соответствует ожидаемому значению", campaign.getInventoryTypeCoef().getInterstitial(), equalTo(MULTIPLIER_PCT1));
    }

    @Test
    public void checkBannerTypeCoef_CpmVideoAndInventoryInStream() {
        BannerTypeMultiplierValuesRecord multiplierBT = new BannerTypeMultiplierValuesRecord()
                .setBannerType(BannerTypeMultiplierValuesBannerType.cpm_video)
                .setMultiplierPct(MULTIPLIER_PCT1);
        InventoryMultiplierValuesRecord multiplierINV = new InventoryMultiplierValuesRecord()
                .setInventoryType(InventoryMultiplierValuesInventoryType.instream_web)
                .setMultiplierPct(MULTIPLIER_PCT2);

        saveBannerTypeMultipliers(singletonList(multiplierBT));
        saveInventoryMultipliers(singletonList(multiplierINV));

        Campaign campaign = sendMultiplierToBsAndGetResultCampaign();

        assumeThat("в БК отправлена кампания", campaign, notNullValue());
        assumeThat("Значение InPage соответствует ожидаемому значению", campaign.getInventoryTypeCoef().getInpage(), equalTo(MULTIPLIER_PCT1));
        assumeThat("Значение InStream соответствует ожидаемому значению", campaign.getInventoryTypeCoef().getInstream_web(), equalTo(MULTIPLIER_PCT2));
        assumeThat("Значение InApp соответствует ожидаемому значению", campaign.getInventoryTypeCoef().getInterstitial(), equalTo(MULTIPLIER_PCT1));
    }

    @Test
    public void checkBannerTypeCoef_CpmBannerAndCpmVideoAndInventoryInPageAndInventoryInApp() {
        BannerTypeMultiplierValuesRecord multiplierBT1 = new BannerTypeMultiplierValuesRecord()
                .setBannerType(BannerTypeMultiplierValuesBannerType.cpm_banner)
                .setMultiplierPct(MULTIPLIER_PCT1);
        BannerTypeMultiplierValuesRecord multiplierBT2 = new BannerTypeMultiplierValuesRecord()
                .setBannerType(BannerTypeMultiplierValuesBannerType.cpm_video)
                .setMultiplierPct(MULTIPLIER_PCT2);
        InventoryMultiplierValuesRecord multiplierINV1 = new InventoryMultiplierValuesRecord()
                .setInventoryType(InventoryMultiplierValuesInventoryType.inpage)
                .setMultiplierPct(MULTIPLIER_PCT3);
        InventoryMultiplierValuesRecord multiplierINV2 = new InventoryMultiplierValuesRecord()
                .setInventoryType(InventoryMultiplierValuesInventoryType.interstitial)
                .setMultiplierPct(MULTIPLIER_PCT4);

        saveBannerTypeMultipliers(Arrays.asList(multiplierBT1, multiplierBT2));
        saveInventoryMultipliers(Arrays.asList(multiplierINV1, multiplierINV2));

        Campaign campaign = sendMultiplierToBsAndGetResultCampaign();

        assumeThat("в БК отправлена кампания", campaign, notNullValue());
        assumeThat("Значение BannerType соответствует ожидаемому значению", campaign.getProductTypeCoef().getBannerType(), equalTo(MULTIPLIER_PCT1));
        assumeThat("Значение InPage соответствует ожидаемому значению", campaign.getInventoryTypeCoef().getInpage(), equalTo(MULTIPLIER_PCT3));
        assumeThat("Значение InStream соответствует ожидаемому значению", campaign.getInventoryTypeCoef().getInstream_web(), equalTo(MULTIPLIER_PCT2));
        assumeThat("Значение InApp соответствует ожидаемому значению", campaign.getInventoryTypeCoef().getInterstitial(), equalTo(MULTIPLIER_PCT4));
    }

    @Test
    public void checkBannerTypeCoef_InventoryNotAllDefined() {
        InventoryMultiplierValuesRecord multiplierINV1 = new InventoryMultiplierValuesRecord()
                .setInventoryType(InventoryMultiplierValuesInventoryType.inpage)
                .setMultiplierPct(MULTIPLIER_PCT1);
        InventoryMultiplierValuesRecord multiplierINV2 = new InventoryMultiplierValuesRecord()
                .setInventoryType(InventoryMultiplierValuesInventoryType.interstitial)
                .setMultiplierPct(MULTIPLIER_PCT2);

        saveInventoryMultipliers(Arrays.asList(multiplierINV1, multiplierINV2));

        Campaign campaign = sendMultiplierToBsAndGetResultCampaign();

        assumeThat("в БК отправлена кампания", campaign, notNullValue());
        assumeThat("Значение InPage соответствует ожидаемому значению", campaign.getInventoryTypeCoef().getInpage(), equalTo(MULTIPLIER_PCT1));
        assumeThat("Значение InStream соответствует ожидаемому значению", campaign.getInventoryTypeCoef().getInstream_web(), equalTo(null));
        assumeThat("Значение InApp соответствует ожидаемому значению", campaign.getInventoryTypeCoef().getInterstitial(), equalTo(MULTIPLIER_PCT2));
    }

    @Test
    public void deleteBannerTypeCoef_CpmBannerOnly() {

        Campaign campaign = sendMultiplierToBsAndGetResultCampaign();

        assumeThat("в БК отправлена кампания", campaign, notNullValue());
        assumeThat("Значение BannerType отправленно как null - удаление корректировки", campaign.getProductTypeCoef().getBannerType(), equalTo(null));
        assumeThat("Значение Inventory отправленно как null - удаление корректировки", campaign.getInventoryTypeCoef(), equalTo(null));
    }

    private void saveInventoryMultipliers(List<InventoryMultiplierValuesRecord> multipliers) {
        api.userSteps.getDirectJooqDbSteps().useShard(shard).multipliersSteps().saveInventoryModifierValues(cid, true, multipliers);
    }
    private void saveBannerTypeMultipliers(List<BannerTypeMultiplierValuesRecord> multipliers) {
        api.userSteps.getDirectJooqDbSteps().useShard(shard).multipliersSteps().saveBannerTypeModifierValues(cid, true, multipliers);
    }

    private Campaign sendMultiplierToBsAndGetResultCampaign() {
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

       return api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
    }
}
