package ru.yandex.autotests.directintapi.bstransport.main.cpmbanner.transmit;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.CreativeBannerRule;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PerfCreativesCreativeType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PerfCreativesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersPerformanceRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PerfCreativesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.campaigns.CampaignTypeEnum;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.direct.web.api.core.DirectRule;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.displaycanvas.ModerationInfo;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.irt.testutils.allure.TestSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;
import static ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies.onlyExpectedFields;

/**
 * Этот тип баннера почти не отличается от cpm video, indoor/outdoor.
 * Баннер передаётся аналогично через
 * <pre>
 * "Resources": {
 *     "AutoVideoCreative": "<>"
 * }
 * </pre>,
 * а в креативе должен быть установлен флаг
 * <pre>
 * "IsAudioCreative": 1
 * </pre>
 * Другие флаги вида "IsVideoCreative" должны отсутствовать (либо быть установленными в 0).
 */
@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Description("Проверяем отправку полей в cpm_audio баннере")
@Features(FeatureNames.CPM_AUDIO)
@Issue("https://st.yandex-team.ru/DIRECT-97820")
public class SendingOfCpmAudioBannerFieldsTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    private static final String PIXEL = "https://mc.yandex.ru/%aw_random%";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static DirectCmdRule defaultClassRule = DirectCmdRule.defaultClassRule();

    public CreativeBannerRule bannersRule = new CreativeBannerRule(CampaignTypeEnum.TEXT).withUlogin(LOGIN);

    @ClassRule
    public static DirectRule directRule = DirectRule.defaultRule().as(LOGIN);

    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().withRules(bannersRule);

    private static int shard;
    private static DirectJooqDbSteps jooqDbSteps;
    private Long cid;
    private Long pid;
    private Long bid;
    public TransportHelpSteps helpSteps;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        helpSteps = new TransportHelpSteps(api).useDbJooqSteps(jooqDbSteps);

        cid = bannersRule.getCampaignId();
        Long creativeId = bannersRule.getCreativeId();
        bid = bannersRule.getBannerId();
        pid = bannersRule.getGroupId();

        Long retargetingConditionId = helpSteps.addRetargetingListsForUserIfNotExists(LOGIN).get(0);
        api.userSteps.audienceTargetsSteps().addWithRetargetingList(pid, retargetingConditionId);

        jooqDbSteps.campaignsSteps().setType(cid, CampaignsType.cpm_banner);
        jooqDbSteps.adGroupsSteps().setType(pid, PhrasesAdgroupType.cpm_audio);
        jooqDbSteps.bannersSteps().setBannersBannerType(bid, BannersBannerType.cpm_audio);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        jooqDbSteps.bannersPerformanceSteps()
                .setCreativeStatusModerate(cid, pid, bid, BannersPerformanceStatusmoderate.Yes);
        PerfCreativesRecord perfCreativesRecord = jooqDbSteps.perfCreativesSteps().getPerfCreatives(creativeId);

        // audio креатив
        perfCreativesRecord.setCreativeType(PerfCreativesCreativeType.video_addition);
        perfCreativesRecord.setLayoutId(301L);

        perfCreativesRecord.setModerateInfo(new ModerationInfo().generateTestData().toString());
        perfCreativesRecord.setStatusmoderate(PerfCreativesStatusmoderate.Yes);
        jooqDbSteps.perfCreativesSteps().updatePerfCreatives(perfCreativesRecord);

        // Добавим счётчик показов для баннера
        jooqDbSteps.pixelsSteps().createAndSaveNewPixelForBanner(bid, PIXEL);
    }

    @Test
    public void testSendingToBsCommonFields() {
        RunBsTransportScriptResponse resp
                = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner banner = context != null ? context.getBanner(bid) : null;
        TestSteps.assumeThat("в запросе есть audio баннер", banner, notNullValue());

        Banner expectedBanner = helpSteps.buildExpectedNewCpmAudioBannerFromDb(bid);

        assertThat("параметры cpm_audio баннера соответсвуют ожиданиям", banner,
                beanDiffer(expectedBanner).useCompareStrategy(onlyExpectedFields()));
    }

    @Test
    public void testSendingToBsExtractedText() {
        BannersPerformanceRecord record = jooqDbSteps.bannersPerformanceSteps().getBannersPerformance(cid, pid, bid);
        record.setExtractedText("long text to split in body long text to split in body");
        jooqDbSteps.bannersPerformanceSteps().updateBannersPerformance(record);
        RunBsTransportScriptResponse resp
                = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner banner = context != null ? context.getBanner(bid) : null;
        TestSteps.assumeThat("в запросе есть cpm-audio баннер", banner, notNullValue());

        Banner expectedBanner = helpSteps.buildExpectedNewCpmAudioBannerFromDb(bid);
        expectedBanner.setTitle("long text to split in body long");
        expectedBanner.setBody("text to split in body");

        assertThat("параметры cpm-audio баннера соответсвуют ожиданиям", banner,
                beanDiffer(expectedBanner).useCompareStrategy(onlyExpectedFields()));
    }
}
