package ru.yandex.autotests.directintapi.bstransport.main.cpmbanner.transmit;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.CreativeBannerRule;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerTurbolandingsStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPhoneflag;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusbssynced;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.campaigns.CampaignTypeEnum;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.steps.TransportSteps;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК баннера с турбой без ссылки")
@Stories(StoriesNames.BANNER_PARAMS_HREF)
@Features(FeatureNames.BANNERS)
public class SendingOfCpmBannerWithTurbolandingWithoutHrefTest {
    public static final String LOGIN = Logins.LOGIN_TRANSPORT_IMG_AD;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @ClassRule
    public static DirectCmdRule defaultClassRule = DirectCmdRule.defaultClassRule();

    public CreativeBannerRule bannersRule = new CreativeBannerRule(CampaignTypeEnum.TEXT).withUlogin(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);
    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().withRules(bannersRule);

    public RunBsTransportScriptResponse resp;
    private int shard;
    private Long cid;
    private Long pid;
    private Long bid;
    private DirectJooqDbSteps jooqDbSteps;
    private TransportSteps transportSteps;

    @Before
    public void basicInit() {
        api.as(LOGIN);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
        transportSteps = api.userSteps.getDarkSideSteps().getTransportSteps();
        shard = jooqDbSteps.getCurrentPpcShard();

        cid = bannersRule.getCampaignId();
        bid = bannersRule.getBannerId();
        pid = bannersRule.getGroupId();
        Long keywordId = bannersRule.getCurrentGroup().getPhrases().get(0).getId();

        Long clientId = jooqDbSteps.usersSteps().getUser(LOGIN).getClientid();
        long tlId = jooqDbSteps.turboLandingsSteps().createDefaultTurbolanding(clientId);
        jooqDbSteps.bannerTurbolandingsSteps()
                .linkTurbolandingToBanner(bid, cid, tlId, false, BannerTurbolandingsStatusmoderate.Yes);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        jooqDbSteps.bannersPerformanceSteps()
                .setCreativeStatusModerate(cid, pid, bid, BannersPerformanceStatusmoderate.Yes);
        api.userSteps.campaignFakeSteps().setType(cid,
                ru.yandex.autotests.directapi.darkside.model.CampaignsType.CPM_BANNER);
        jooqDbSteps.adGroupsSteps().setType(pid, PhrasesAdgroupType.cpm_banner);
        jooqDbSteps.bannersSteps().setBannersBannerType(bid, BannersBannerType.cpm_banner);
        jooqDbSteps.bannersSteps().setBannersHref(bid, null);
        jooqDbSteps.bannersSteps().setBannersDomain(bid, null);
        jooqDbSteps.bannersSteps().setPhoneflag(bid, BannersPhoneflag.New);
    }

    @Test
    public void testSendingToBs_NewCampaign() {
        jooqDbSteps.campaignsSteps().setCampaignsStatusBsSynced(cid, CampaignsStatusbssynced.No);
        sendAndCheckResponse(resp = transportSteps.sendNewCampaign(shard, cid));
    }

    @Test
    public void testSendingToBs_CampaignAlreadySynced() {
        sendAndCheckResponse(resp = transportSteps.sendNewCampaign(shard, cid));
        jooqDbSteps.bannersSteps().setBannerStatusBsSynced(bid, BannersStatusbssynced.No);
        jooqDbSteps.adGroupsSteps().setPhrasesStatusBsSynced(bid, PhrasesStatusbssynced.No);
        sendAndCheckResponse(resp = transportSteps.sendSyncedCampaign(shard, cid));
    }

    private void sendAndCheckResponse(RunBsTransportScriptResponse runBsTransportScriptResponse) {
        Campaign campaign = transportSteps.getClientDataRequestCampaign(runBsTransportScriptResponse, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner banner = context != null ? context.getBanner(bid) : null;
        assertThat("баннер должен уйти в БК", banner, notNullValue());
    }
}
