package ru.yandex.autotests.directintapi.bstransport.main.cpmbanner.transmit;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PerfCreativesCreativeType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PerfCreativesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.RetargetingConditionsRetargetingConditionsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PerfCreativesRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.RetargetingConditionsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.displaycanvas.ModerationInfo;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.irt.testutils.allure.TestSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsEqual.equalTo;
import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps.PICTURE_BANNER_BODY;
import static ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps.PICTURE_BANNER_TITLE;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;
import static ru.yandex.autotests.irt.testutils.beandiffer2.beanfield.BeanFieldPath.newPath;
import static ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies.onlyExpectedFields;
import static ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies.onlyFields;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Description("Проверяем отправку полей в cpm видео баннере")
@Features(FeatureNames.CPM_BANNER)
@Issue("https://st.yandex-team.ru/DIRECT-131519")
public class SendingOfCpmVideoBannerFieldsTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static DirectJooqDbSteps jooqDbSteps;
    private static TransportHelpSteps helpSteps;

    private static int shard;

    private Long cid;
    private Long pid;
    private Long bid;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        helpSteps = new TransportHelpSteps(api).useDbJooqSteps(jooqDbSteps);

        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        Long creativeId = jooqDbSteps.perfCreativesSteps()
                .saveDefaultCanvasCreativesForClient(Long.parseLong(User.get(LOGIN).getClientID()));

        cid = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultCpmBannerAdBuilderAd(pid, creativeId);
        jooqDbSteps.adGroupsSteps().setType(pid, PhrasesAdgroupType.cpm_video);

        Long clientId = Long.parseLong(api.userSteps.clientFakeSteps().getClientData(LOGIN).getClientID());
        RetargetingConditionsRecord record = new RetargetingConditionsRecord()
                .setClientid(clientId)
                .setRetargetingConditionsType(RetargetingConditionsRetargetingConditionsType.interests)
                .setConditionName("name")
                .setConditionDesc("description")
                .setConditionJson("[{\"goals\":[{\"goal_type\":\"social_demo\",\"goal_id\":2499000003,\"time\":0}]," +
                        "\"type\":\"or\",\"interest_type\":null,\"section_id\":null}]")
                .setIsDeleted(0)
                .setProperties("negative");

        long retargetingConditionId = jooqDbSteps.retargetingConditionSteps().addRetargetingCondition(record, clientId);
        api.userSteps.audienceTargetsSteps().addWithRetargetingList(pid, retargetingConditionId);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        jooqDbSteps.bannersPerformanceSteps()
                .setCreativeStatusModerate(cid, pid, bid, BannersPerformanceStatusmoderate.Yes);
        PerfCreativesRecord perfCreativesRecord = jooqDbSteps.perfCreativesSteps().getPerfCreatives(creativeId);
        perfCreativesRecord.setModerateInfo(new ModerationInfo().generateTestData().toString());
        perfCreativesRecord.setStatusmoderate(PerfCreativesStatusmoderate.Yes);
        perfCreativesRecord.setCreativeType(PerfCreativesCreativeType.video_addition);
        perfCreativesRecord.setLayoutId(1L);
        jooqDbSteps.perfCreativesSteps().updatePerfCreatives(perfCreativesRecord);
    }

    @Test
    public void testSendingToBsCommonFields() {
        Banner expectedBanner = helpSteps.buildExpectedCpmVideoBannerFromDb(bid);
        expectedBanner.setTitle(PICTURE_BANNER_TITLE);   //фейковый
        expectedBanner.setBody(PICTURE_BANNER_BODY);     //фейковый
        expectedBanner.setIsFakeTitle(1);
        expectedBanner.setIsFakeBody(1);
        checkTransportResponse(expectedBanner);
    }

    @Test
    public void testSendingToBsCommonFieldsWithTitleAndBody() {
        BannersRecord bannersRecord = jooqDbSteps.bannersSteps().getBanner(bid);
        bannersRecord.setTitle("title");
        bannersRecord.setBody("body");
        jooqDbSteps.bannersSteps().updateBanners(bannersRecord);

        Banner expectedBanner = helpSteps.buildExpectedCpmVideoBannerFromDb(bid);
        expectedBanner.setTitle("title");
        expectedBanner.setBody("body");
        expectedBanner.setIsFakeTitle(null);
        expectedBanner.setIsFakeBody(null);
        checkTransportResponse(expectedBanner);
    }

    private void checkTransportResponse(Banner expectedBanner) {
        RunBsTransportScriptResponse resp
                = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Banner banner = context != null ? context.getBanner(bid) : null;
        TestSteps.assumeThat("в запросе есть cpm баннер", banner, notNullValue());

        assertThat("параметры cpm видео баннера соответствуют ожиданиям", banner,
                beanDiffer(expectedBanner).useCompareStrategy(onlyExpectedFields()));

        //IsFakeTitle и IsFakeBody могут быть null и onlyExpectedFields их не проверит
        assertThat("параметры cpm видео баннера соответствуют ожиданиям", banner,
                beanDiffer(expectedBanner).useCompareStrategy(onlyFields(newPath("isFakeTitle"),
                        newPath("isFakeBody"))));
    }
}
