package ru.yandex.autotests.directintapi.bstransport.main.cpmbanner.transmit;

import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Description("Проверяем отправку баннеров с пикселями")
@Features(FeatureNames.CPM_BANNER)
@Issue("https://st.yandex-team.ru/DIRECT-72893")
public class SendingPixelsTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final String YNDX_AUDIENCE_PIXEL = "https://mc.yandex.ru/pixel";
    private static final String TNS_PIXEL = "https://www.tns-counter.ru/pixel";
    private static final String ADFOX_PIXEL = "https://ads.adfox.ru/pixel";
    private static final String EXPECTED_ADFOX_PIXEL = "https://ads.adfox.ru/pixel&b_id={BID}&c_id={HLID}&o_id={OID}";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long bidWithoutPixels;
    private static Long bidWithOnePixel;
    private static Long bidWithTwoPixels;
    private static Context context;

    @BeforeClass
    public static void configImages() {
        int shard = api.userSteps.getDarkSideSteps().getClientFakeSteps().getUserShard(LOGIN);
        Long clientId = Long.valueOf(api.userSteps.clientFakeSteps().getClientData(LOGIN).getClientID());
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bidWithoutPixels = api.userSteps.adsSteps().addDefaultTextAd(pid);
        bidWithOnePixel = api.userSteps.adsSteps().addDefaultTextAd(pid);
        bidWithTwoPixels = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        Long creativeId = jooqDbSteps.perfCreativesSteps().saveDefaultCanvasCreativesForClient(clientId);
        jooqDbSteps.bannersPerformanceSteps().saveNewBannersPerformance(cid, pid, bidWithoutPixels, creativeId);
        jooqDbSteps.bannersPerformanceSteps()
                .setCreativeStatusModerate(cid, pid, bidWithoutPixels, BannersPerformanceStatusmoderate.Yes);
        jooqDbSteps.bannersPerformanceSteps().saveNewBannersPerformance(cid, pid, bidWithOnePixel, creativeId);
        jooqDbSteps.bannersPerformanceSteps()
                .setCreativeStatusModerate(cid, pid, bidWithOnePixel, BannersPerformanceStatusmoderate.Yes);
        jooqDbSteps.bannersPerformanceSteps().saveNewBannersPerformance(cid, pid, bidWithTwoPixels, creativeId);
        jooqDbSteps.bannersPerformanceSteps()
                .setCreativeStatusModerate(cid, pid, bidWithTwoPixels, BannersPerformanceStatusmoderate.Yes);

        jooqDbSteps.pixelsSteps()
                .createAndSaveNewPixelForBanner(bidWithOnePixel, TNS_PIXEL);

        jooqDbSteps.pixelsSteps().createAndSaveNewPixelForBanner(bidWithTwoPixels, YNDX_AUDIENCE_PIXEL);
        jooqDbSteps.pixelsSteps()
                .createAndSaveNewPixelForBanner(bidWithTwoPixels, ADFOX_PIXEL);

        jooqDbSteps.bannersSteps().setBannersBannerType(bidWithoutPixels, BannersBannerType.cpm_banner);
        jooqDbSteps.bannersSteps().setBannersBannerType(bidWithOnePixel, BannersBannerType.cpm_banner);
        jooqDbSteps.bannersSteps().setBannersBannerType(bidWithTwoPixels, BannersBannerType.cpm_banner);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidWithoutPixels);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidWithOnePixel);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidWithTwoPixels);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
    }

    @Test
    public void checkBannerWithoutPixels() {
        Banner banner = context != null ? context.getBanner(bidWithoutPixels) : null;
        assumeThat("в БК отправлен баннер", banner, notNullValue());
        assertThat("в БК отправлен правильный пиксель",
                banner.getViewNoticeHrefs(), nullValue());
    }

    @Test
    public void checkBannerWithOnePixel() {
        Banner banner = context != null ? context.getBanner(bidWithOnePixel) : null;
        assumeThat("в БК отправлен баннер", banner, notNullValue());
        assertThat("в БК отправлен правильный пиксель",
                banner.getViewNoticeHrefs(), equalTo(Arrays.asList(TNS_PIXEL)));
    }

    @Test
    public void checkBannerWithTwoPixels() {
        Banner banner = context != null ? context.getBanner(bidWithTwoPixels) : null;
        assumeThat("в БК отправлен баннер", banner, notNullValue());
        assertThat("в БК отправлен правильный пиксель",
                banner.getViewNoticeHrefs().stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList()),
                equalTo(Stream.of(YNDX_AUDIENCE_PIXEL, EXPECTED_ADFOX_PIXEL).sorted(Comparator.naturalOrder())
                        .collect(Collectors.toList())));
    }
}
