package ru.yandex.autotests.directintapi.bstransport.main.cpmbanner.transmit;

import java.util.Arrays;
import java.util.Collections;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.direct.db.steps.PixelsSteps.replaceRandomMacrosForBS;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Title("Проверяем отправку пикселей с рандом-параметром")
@Features(FeatureNames.CPM_BANNER)
@Issue("https://st.yandex-team.ru/DIRECT-72893")
@RunWith(Parameterized.class)
public class SendingRandomParameterInPixelTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final String YNDX_AUDIENCE_PIXEL_1 = "https://mc.yandex.ru/%aw_random%";
    private static final String YNDX_AUDIENCE_PIXEL_2 = "https://mc.yandex.ru/%random%";
    private static final String YNDX_AUDIENCE_PIXEL_3 = "https://mc.yandex.ru/%25aw_random%25";
    private static final String YNDX_AUDIENCE_PIXEL_4 = "https://mc.yandex.ru/%AW_random%";
    private static final String YNDX_AUDIENCE_PIXEL_NO_RANDOM = "https://mc.yandex.ru/aw_random%";
    //на самом деле это значение невалидно и не пройдет валидацию в ядре
    private static final String TNS_PIXEL_1 = "https://www.tns-counter.ru/%aw_random%";
    private static final String TNS_PIXEL_2 = "https://www.tns-counter.ru/%random%";
    private static final String TNS_PIXEL_NO_RANDOM = "https://www.tns-counter.ru/%aw_random";
    private static final String ADFOX_PIXEL_1 = "https://ads.adfox.ru/%random%";
    private static final String EXPECTED_ADFOX_PIXEL_1 = "https://ads.adfox.ru/%random%&b_id={BID}&c_id={HLID}&o_id={OID}";
    private static final String ADFOX_PIXEL_2 = "https://ads.adfox.ru/%aw_random%";
    private static final String EXPECTED_ADFOX_PIXEL_2 = "https://ads.adfox.ru/%aw_random%&b_id={BID}&c_id={HLID}&o_id={OID}";
    private static final String ADFOX_PIXEL_NO_RANDOM = "https://ads.adfox.ru/random";
    private static final String EXPECTED_ADFOX_PIXEL_NO_RANDOM = "https://ads.adfox.ru/random&b_id={BID}&c_id={HLID}&o_id={OID}";
    private static final String ADRIVER_PIXEL_1 = "https://ad.adriver.ru/%random%";
    private static final String ADRIVER_PIXEL_2 = "https://ad.adriver.ru/%aw_random%";
    private static final String WEBORAMA_PIXEL_1 = "https://wcm.solution.weborama.fr/%random%";
    private static final String WEBORAMA_PIXEL_2 = "https://wcm.solution.weborama.fr/%aw_random%";
    private static final String SIZMEK_PIXEL_1 = "https://bs.serving-sys.com/%random%";
    private static final String SIZMEK_PIXEL_2 = "https://bs.serving-sys.com/%aw_random%";
    private static final String DCM_PIXEL_1 = "https://ad.doubleclick.net/%random%";
    private static final String DCM_PIXEL_2 = "https://ad.doubleclick.net/%aw_random%";

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static int shard;
    private static Long clientId;
    private Context context;
    private Long bid;

    @Parameterized.Parameter(0)
    public String pixel;

    @Parameterized.Parameter(1)
    public String expectedPixel;

    @Parameterized.Parameters(name = "pixel = {0}, expectedPixel = {1}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {YNDX_AUDIENCE_PIXEL_1, YNDX_AUDIENCE_PIXEL_1},
                {YNDX_AUDIENCE_PIXEL_2, YNDX_AUDIENCE_PIXEL_2},
                {YNDX_AUDIENCE_PIXEL_3, YNDX_AUDIENCE_PIXEL_3},
                {YNDX_AUDIENCE_PIXEL_4, YNDX_AUDIENCE_PIXEL_4},
                {YNDX_AUDIENCE_PIXEL_NO_RANDOM, YNDX_AUDIENCE_PIXEL_NO_RANDOM},
                {TNS_PIXEL_1, TNS_PIXEL_1},
                {TNS_PIXEL_2, TNS_PIXEL_2},
                {TNS_PIXEL_NO_RANDOM, TNS_PIXEL_NO_RANDOM},
                {ADFOX_PIXEL_1, EXPECTED_ADFOX_PIXEL_1},
                {ADFOX_PIXEL_2, EXPECTED_ADFOX_PIXEL_2},
                {ADFOX_PIXEL_NO_RANDOM, EXPECTED_ADFOX_PIXEL_NO_RANDOM},
                {ADRIVER_PIXEL_1, ADRIVER_PIXEL_1},
                {ADRIVER_PIXEL_2, ADRIVER_PIXEL_2},
                {WEBORAMA_PIXEL_1, WEBORAMA_PIXEL_1},
                {WEBORAMA_PIXEL_2, WEBORAMA_PIXEL_2},
                {SIZMEK_PIXEL_1, SIZMEK_PIXEL_1},
                {SIZMEK_PIXEL_2, SIZMEK_PIXEL_2},
                {DCM_PIXEL_1, DCM_PIXEL_1},
                {DCM_PIXEL_2, DCM_PIXEL_2}
        });
    }

    @BeforeClass
    public static void configImages() {
        shard = api.userSteps.getDarkSideSteps().getClientFakeSteps().getUserShard(LOGIN);
        clientId = Long.valueOf(api.userSteps.clientFakeSteps().getClientData(LOGIN).getClientID());
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createBanner() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        Long creativeId = jooqDbSteps.perfCreativesSteps().saveDefaultCanvasCreativesForClient(clientId);
        jooqDbSteps.bannersPerformanceSteps().saveNewBannersPerformance(cid, pid, bid, creativeId);
        jooqDbSteps.bannersPerformanceSteps()
                .setCreativeStatusModerate(cid, pid, bid, BannersPerformanceStatusmoderate.Yes);
        jooqDbSteps.pixelsSteps()
                .createAndSaveNewPixelForBanner(bid, pixel);
        jooqDbSteps.bannersSteps().setBannersBannerType(bid, BannersBannerType.cpm_banner);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
    }


    @Test
    public void checkMacrosInBannerHref() {
        Banner banner = context != null ? context.getBanner(bid) : null;
        assumeThat("в БК отправлен баннер", banner, notNullValue());
        expectedPixel = replaceRandomMacrosForBS(expectedPixel);
        assertThat("в БК отправлен правильный пиксель",
                banner.getViewNoticeHrefs(), equalTo(Collections.singletonList(expectedPixel))
        );
    }
}
