package ru.yandex.autotests.directintapi.bstransport.main.cpmbanner.transmit;

import java.math.RoundingMode;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.CreativeBannerRule;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.db.beans.campaign.StrategyData;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampOptionsStrategy;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsAutobudget;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsPlatform;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStrategyName;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PerfCreativesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.StrategiesType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.StrategiesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.campaigns.CampaignTypeEnum;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.displaycanvas.ModerationInfo;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.irt.testutils.allure.TestSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.directintapi.bstransport.TransportUtils.CPM_COEF;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Description("Проверяем отправку cpm стратегий")
@Features(FeatureNames.CPM_BANNER)
@Issue("https://st.yandex-team.ru/DIRECT-69250")
public class SendingStrategiesOfCpmBannerTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT_IMG_AD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static DirectCmdRule defaultClassRule = DirectCmdRule.defaultClassRule();

    public CreativeBannerRule bannersRule = new CreativeBannerRule(CampaignTypeEnum.TEXT).withUlogin(LOGIN);

    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().withRules(bannersRule);

    private static int shard;
    private Long cid;
    private Long pid;
    private Long bid;
    private DirectJooqDbSteps jooqDbSteps;
    private TransportHelpSteps helpSteps;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        cid = bannersRule.getCampaignId();
        Long creativeId = bannersRule.getCreativeId();
        bid = bannersRule.getBannerId();
        pid = bannersRule.getGroupId();
        Long keywordId = bannersRule.getCurrentGroup().getPhrases().get(0).getId();

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        helpSteps = new TransportHelpSteps(api).useDbJooqSteps(jooqDbSteps);
        jooqDbSteps.bannersPerformanceSteps()
                .setCreativeStatusModerate(cid, pid, bid, BannersPerformanceStatusmoderate.Yes);
        jooqDbSteps.perfCreativesSteps().setModerateInfo(creativeId,
                new ModerationInfo().generateTestData().toString());
        jooqDbSteps.perfCreativesSteps().setStatusModerate(creativeId, PerfCreativesStatusmoderate.Yes);
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(cid)
                                .withTextCampaign(new TextCampaignUpdateItemMap()
                                        .withBiddingStrategy(new TextCampaignStrategyMap()
                                                .withSearch(new TextCampaignSearchStrategyMap().defaultServingOff())
                                                .withNetwork(new TextCampaignNetworkStrategyMap().defaultMaximumCoverage())))),
                ExpectedResult.success());
    }

    @Test
    public void testCpmDefault() {
        CampaignsRecord campaignsRecord = jooqDbSteps.campaignsSteps().getCampaignById(cid);
        campaignsRecord.setStrategyName(CampaignsStrategyName.cpm_default);
        campaignsRecord.setPlatform(CampaignsPlatform.context);
        StrategyData strategyData = new StrategyData().withName(CampaignsStrategyName.cpm_default);
        campaignsRecord.setStrategyData(strategyData.toJsonElement());

        Long strategyId =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(cid).getStrategyId();
        if (strategyId != 0) {
            StrategiesRecord strategiesRecord =
                    api.userSteps.getDirectJooqDbSteps().useShard(shard).strategiesSteps().getStrategiesRecord(strategyId);
            strategiesRecord.setType(StrategiesType.cpm_default);
            strategiesRecord.setStrategyData(strategyData.toJsonElement().toString());
            api.userSteps.getDirectJooqDbSteps().useShard(shard).strategiesSteps().updateStrategies(strategiesRecord);
        }

        jooqDbSteps.campaignsSteps().updateCampaigns(campaignsRecord);
        jooqDbSteps.adGroupsSteps().setType(pid, PhrasesAdgroupType.cpm_banner);
        jooqDbSteps.bannersSteps().setBannersBannerType(bid, BannersBannerType.cpm_banner);
        jooqDbSteps.campaignsSteps().setCampOptionsStrategy(cid, CampOptionsStrategy.different_places);
        RunBsTransportScriptResponse
                resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign
                = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        TestSteps.assumeThat("в запросе есть кампания", campaign, notNullValue());

        Campaign expectedCampaign = helpSteps.buildExpectedCampaignObjFromDb(cid, shard, UpdateInfo.UPDATE);
        expectedCampaign.setAutoBudgetOptimizeRF(0);
        expectedCampaign.setRfDecay(0d);
        expectedCampaign.setRfMinCPM(1);

        assertThat("параметры стратегии соответсвуют ожиданиям",
                campaign,
                helpSteps.campaignReq1Matcher(expectedCampaign));
    }

    @Test
    public void testAutobudgetMaxReach() {
        Money avgCpm = MoneyCurrency.get(Currency.RUB).getMinCpmPrice();
        Money sum =
                MoneyCurrency.get(Currency.RUB).getMaxWeeklyBudgetAmount().divide(10f);
        CampaignsRecord campaignsRecord = jooqDbSteps.campaignsSteps().getCampaignById(cid);
        campaignsRecord.setStrategyName(CampaignsStrategyName.autobudget_max_reach);
        campaignsRecord.setPlatform(CampaignsPlatform.context);
        StrategyData strategyData = new StrategyData()
                .withName(CampaignsStrategyName.autobudget_max_reach)
                .withSum(sum.doubleValue())
                .withAvgCpm(avgCpm.doubleValue());
        campaignsRecord.setStrategyData(strategyData.toJsonElement());
        campaignsRecord.setAutobudget(CampaignsAutobudget.Yes);
        jooqDbSteps.campaignsSteps().updateCampaigns(campaignsRecord);

        Long strategyId =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(cid).getStrategyId();
        if (strategyId != 0) {
            StrategiesRecord strategiesRecord =
                    api.userSteps.getDirectJooqDbSteps().useShard(shard).strategiesSteps().getStrategiesRecord(strategyId);
            strategiesRecord.setType(StrategiesType.autobudget_max_reach);
            strategiesRecord.setStrategyData(strategyData.toJsonElement().toString());
            api.userSteps.getDirectJooqDbSteps().useShard(shard).strategiesSteps().updateStrategies(strategiesRecord);
        }

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign
                = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        TestSteps.assumeThat("в запросе есть кампания", campaign, notNullValue());

        Campaign expectedCampaign = helpSteps.buildExpectedCampaignObjFromDb(cid, shard, UpdateInfo.UPDATE);
        expectedCampaign.setAutoBudgetOptimizeRF(1);
        expectedCampaign.setRfDecay(0.16d);
        expectedCampaign.setRfMinCPM(0);
        expectedCampaign.setAutoBudgetAvgCPMCur(avgCpm.addVAT().divide(CPM_COEF)
                .setScale(Campaign.PRECISION_DIGIT_COUNT_RUB, RoundingMode.HALF_UP)
                .floatValue());
        expectedCampaign.setAutoBudgetWeekLimitCur(sum.addVAT()
                .setScale(Campaign.PRECISION_DIGIT_COUNT_RUB, RoundingMode.HALF_UP)
                .floatValue());
        // здесь можно было бы также проверить значение AutoBudgetAvgCPM и AutoBudgetWeekLimit,
        // но вычисление этих полей не пережило переход на НДС 20%, и теперь они вычисляются неправильно.
        // Это сознательно решили не исправлять, см. https://st.yandex-team.ru/DIRECT-88492

        assertThat("параметры стратегии соответсвуют ожиданиям",
                campaign,
                helpSteps.campaignReq1Matcher(expectedCampaign));
    }

    @Test
    public void testAutobudgetMaxImpressions() {
        Money avgCpm = MoneyCurrency.get(Currency.RUB).getMinCpmPrice();
        Money sum =
                MoneyCurrency.get(Currency.RUB).getMaxWeeklyBudgetAmount().divide(10f);
        CampaignsRecord campaignsRecord = jooqDbSteps.campaignsSteps().getCampaignById(cid);
        campaignsRecord.setStrategyName(CampaignsStrategyName.autobudget_max_impressions);
        campaignsRecord.setPlatform(CampaignsPlatform.context);
        StrategyData strategyData = new StrategyData()
                .withName(CampaignsStrategyName.autobudget_max_impressions)
                .withSum(sum.doubleValue())
                .withAvgCpm(avgCpm.doubleValue());
        campaignsRecord.setStrategyData(strategyData.toJsonElement());
        campaignsRecord.setAutobudget(CampaignsAutobudget.Yes);
        jooqDbSteps.campaignsSteps().updateCampaigns(campaignsRecord);

        Long strategyId =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(cid).getStrategyId();
        if (strategyId != 0) {
            StrategiesRecord strategiesRecord =
                    api.userSteps.getDirectJooqDbSteps().useShard(shard).strategiesSteps().getStrategiesRecord(strategyId);
            strategiesRecord.setType(StrategiesType.autobudget_max_impressions);
            strategiesRecord.setStrategyData(strategyData.toJsonElement().toString());
            api.userSteps.getDirectJooqDbSteps().useShard(shard).strategiesSteps().updateStrategies(strategiesRecord);
        }

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign
                = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        TestSteps.assumeThat("в запросе есть кампания", campaign, notNullValue());

        Campaign expectedCampaign = helpSteps.buildExpectedCampaignObjFromDb(cid, shard, UpdateInfo.UPDATE);
        expectedCampaign.setAutoBudgetOptimizeRF(1);
        expectedCampaign.setRfDecay(0d);
        expectedCampaign.setRfMinCPM(1);
        expectedCampaign.setAutoBudgetAvgCPMCur(avgCpm.addVAT().divide(CPM_COEF)
                .setScale(Campaign.PRECISION_DIGIT_COUNT_RUB, RoundingMode.HALF_UP)
                .floatValue());
        expectedCampaign.setAutoBudgetWeekLimitCur(sum.addVAT()
                .setScale(Campaign.PRECISION_DIGIT_COUNT_RUB, RoundingMode.HALF_UP)
                .floatValue());
        // здесь можно было бы также проверить значение AutoBudgetAvgCPM и AutoBudgetWeekLimit,
        // но вычисление этих полей не пережило переход на НДС 20%, и теперь они вычисляются неправильно.
        // Это сознательно решили не исправлять, см. https://st.yandex-team.ru/DIRECT-88492

        assertThat("параметры стратегии соответсвуют ожиданиям",
                campaign,
                helpSteps.campaignReq1Matcher(expectedCampaign));
    }
}
