package ru.yandex.autotests.directintapi.bstransport.main.cpmdeals.queue;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.CreativeBannerRule;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.utils.campaigns.CampaignTypeEnum;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.setBannerStatuses;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Транспорт: проверка постановки в очередь ppc.bs_export_queue новой кампании cpm_deals")
@Features({FeatureNames.CPM_DEALS, FeatureNames.NOT_FOR_FULL_EXPORT})
@Issue("https://st.yandex-team.ru/DIRECT-75858")
@RunWith(Parameterized.class)
public class BsTransportNewCpmDealsAddToQueueStatusModerateTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT_IMG_AD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static DirectCmdRule defaultClassRule = DirectCmdRule.defaultClassRule();

    public CreativeBannerRule bannersRule = new CreativeBannerRule(CampaignTypeEnum.TEXT).withUlogin(LOGIN);

    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().withRules(bannersRule);

    private static int shard;
    private Long cid;
    private Long pid;
    private Long bid;

    @Parameterized.Parameter()
    public String bannerStatus;
    @Parameterized.Parameter(1)
    public BannersPerformanceStatusmoderate bannersPerformanceStatusmoderate;
    @Parameterized.Parameter(2)
    public Matcher<Object> campaignMatcher;
    @Parameterized.Parameter(3)
    public Matcher<Object> contextAndGroupMatcher;

    @Parameterized.Parameters(name = "статус модерации баннера: {0}, " +
            "статус модерации картинки: {1}, " +
            "ожидаем отправку кампании: {2}, " +
            "ожидаем отправку группы и баннера: {3}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {Status.NO, BannersPerformanceStatusmoderate.No, nullValue(), nullValue()},
                {Status.NEW, BannersPerformanceStatusmoderate.New, notNullValue(), nullValue()},
                {Status.SENT, BannersPerformanceStatusmoderate.Sent, notNullValue(), nullValue()},
                {Status.SENDING, BannersPerformanceStatusmoderate.Sending, notNullValue(), nullValue()},
                {Status.YES, BannersPerformanceStatusmoderate.Yes, notNullValue(), notNullValue()},
                {Status.YES, BannersPerformanceStatusmoderate.No, notNullValue(), nullValue()},
                {Status.NO, BannersPerformanceStatusmoderate.Yes, nullValue(), nullValue()},
        };
        return Arrays.asList(data);
    }


    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        cid = bannersRule.getCampaignId();
        bid = bannersRule.getBannerId();
        pid = bannersRule.getGroupId();

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().setPhraseStatusModerateYes(pid);
        setBannerStatuses(api, bid, bannerStatus, bannerStatus, cid);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersPerformanceSteps()
                .setCreativeStatusModerate(cid, pid, bid, bannersPerformanceStatusmoderate);

        api.userSteps.campaignFakeSteps().setType(cid, CampaignsType.CPM_DEALS);
        api.userSteps.getDirectJooqDbSteps().adGroupsSteps()
                .setType(pid, PhrasesAdgroupType.cpm_banner);
        api.userSteps.getDirectJooqDbSteps().bannersSteps()
                .setBannersBannerType(bid, BannersBannerType.cpm_banner);
    }

    @Test
    public void testAddingToBsQueue() {
        api.userSteps.transportSteps().runBsExportMasterScript(shard, cid);
        RunBsTransportScriptResponse response = api.userSteps.transportSteps().runBsClientDataScript(shard, cid);

        Map camapign = api.userSteps.transportSteps().getRawClientDataLogRequestForCampaign(response, cid);
        assertThat("Ожидаем, что в БК может быть отправлена кампания", camapign, campaignMatcher);

        Map context = api.userSteps.transportSteps().getRawClientDataLogRequestForContext(response, cid, pid);
        assertThat("Ожидаем, что в БК может быть отправлена группа", context, contextAndGroupMatcher);

        Map banner = api.userSteps.transportSteps().getRawClientDataLogRequestForBanner(response, cid, pid, bid);
        assertThat("Ожидаем, что в БК может быть отправлена баннер", banner, contextAndGroupMatcher);
    }
}
