package ru.yandex.autotests.directintapi.bstransport.main.cpmdeals.transmit;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.CreativeBannerRule;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.db.beans.campaign.StrategyData;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsPlatform;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStrategyName;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PerfCreativesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.campaigns.CampaignTypeEnum;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.displaycanvas.ModerationInfo;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.irt.testutils.allure.TestSteps;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.directintapi.bstransport.TransportUtils.CPM_COEF;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Description("Проверяем отправку ставок обычным транспортом")
@Features(FeatureNames.CPM_DEALS)
@Issue("https://st.yandex-team.ru/DIRECT-75858")
public class SendingPricesInUpdateDataTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT_IMG_AD;
    private static final Money PRICE = Money.valueOf(0);
    private static final Money PRICE_CONTEXT = MoneyCurrency.get(Currency.RUB).getMinCpmPrice();

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static DirectCmdRule defaultClassRule = DirectCmdRule.defaultClassRule();

    public CreativeBannerRule bannersRule = new CreativeBannerRule(CampaignTypeEnum.TEXT).withUlogin(LOGIN);

    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().withRules(bannersRule);

    private static int shard;
    private Long cid;
    private Long pid;
    private Long keywordId;
    private DirectJooqDbSteps jooqDbSteps;
    private RunBsTransportScriptResponse resp;
    private TransportHelpSteps helpSteps;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        cid = bannersRule.getCampaignId();
        Long creativeId = bannersRule.getCreativeId();
        Long bid = bannersRule.getBannerId();
        pid = bannersRule.getGroupId();
        keywordId = bannersRule.getCurrentGroup().getPhrases().get(0).getId();

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        helpSteps = new TransportHelpSteps(api).useDbJooqSteps(jooqDbSteps);
        jooqDbSteps.bannersPerformanceSteps()
                .setCreativeStatusModerate(cid, pid, bid, BannersPerformanceStatusmoderate.Yes);
        jooqDbSteps.perfCreativesSteps().setModerateInfo(creativeId,
                new ModerationInfo().generateTestData().toString());
        jooqDbSteps.perfCreativesSteps().setStatusModerate(creativeId, PerfCreativesStatusmoderate.Yes);
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(cid)
                                .withTextCampaign(new TextCampaignUpdateItemMap()
                                        .withBiddingStrategy(new TextCampaignStrategyMap()
                                                .withSearch(new TextCampaignSearchStrategyMap().defaultServingOff())
                                                .withNetwork(new TextCampaignNetworkStrategyMap().defaultMaximumCoverage())))),
                ExpectedResult.success());
        api.userSteps.bidsSteps().shouldGetBidResultOnSet(new SetRequestMap()
                        .withBids(new BidSetItemMap()
                                .withKeywordId(keywordId)
                                .withContextBid(PRICE_CONTEXT.bidLong().longValue())),
                BidExpectedResult.successWithKeywordId());
        BidsRecord bidsRecord = jooqDbSteps.bidsSteps().getBidById(keywordId);
        bidsRecord.setPrice(PRICE.bigDecimalValue());
        jooqDbSteps.bidsSteps().updateBids(bidsRecord);//Через API 0 установить нельзя, поэтому через базу
        CampaignsRecord campaignsRecord = jooqDbSteps.campaignsSteps().getCampaignById(cid);
        campaignsRecord.setStrategyName(CampaignsStrategyName.cpm_default);
        campaignsRecord.setPlatform(CampaignsPlatform.context);
        campaignsRecord.setType(CampaignsType.cpm_deals);
        StrategyData strategyData = new StrategyData().withName(CampaignsStrategyName.cpm_default);
        campaignsRecord.setStrategyData(strategyData.toJsonElement());
        jooqDbSteps.campaignsSteps().updateCampaigns(campaignsRecord);
        jooqDbSteps.adGroupsSteps().setType(pid, PhrasesAdgroupType.cpm_banner);
        jooqDbSteps.bannersSteps().setBannersBannerType(bid, BannersBannerType.cpm_banner);
        resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
    }

    @Test
    public void testPrices() {
        Campaign campaign
                = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Phrase phrase = context != null ? context.getPhrase(keywordId) : null;
        TestSteps.assumeThat("в запросе есть фраза", phrase, notNullValue());

        Phrase expectedPhrase = helpSteps.buildExpectedPhraseObjFromDb(keywordId, shard, UpdateInfo.UPDATE);
        expectedPhrase.setPrice(PRICE.divide(CPM_COEF).stringValue(MoneyFormat.INTEGER));
        expectedPhrase.setPriceContext(PRICE_CONTEXT.divide(CPM_COEF).doubleValue());
        expectedPhrase.setId(null); // PhraseID может успеть записаться в базу, не проверяем его
        assertThat("параметры фразы соответсвуют ожиданиям",
                phrase,
                beanDiffer(expectedPhrase).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }
}
