package ru.yandex.autotests.directintapi.bstransport.main.cpmprice.transmit;

import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;

import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.CreativeBannerRule;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsCpmPriceStatusApprove;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsCpmPriceStatusCorrect;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsPlatform;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusshow;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PerfCreativesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsCpmPriceRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsCpmYndxFrontpageRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.records.CpmPricePackagesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.campaigns.CampaignTypeEnum;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.displaycanvas.ModerationInfo;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Description("Транспорт в БК должен учитывать флаг cpd_pause кампаний на главной")
@Features(FeatureNames.CPM_PRICE)
@Issue("https://st.yandex-team.ru/DIRECT-160247")
@RunWith(Parameterized.class)
public class SendingCpmPriceStopForCpdCampaignsTest {
    private static final String LOGIN = Logins.CHECK_GOALS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static DirectCmdRule defaultClassRule = DirectCmdRule.defaultClassRule();

    public CreativeBannerRule bannersRule = new CreativeBannerRule(CampaignTypeEnum.TEXT).withUlogin(LOGIN);

    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().withRules(bannersRule);

    private static int shard;
    private Long cid;
    private Long rcId;
    private Long atId;
    private Long packageId;

    @Parameterized.Parameter(0)
    public Boolean isCpmPriceCampaign;
    @Parameterized.Parameter(1)
    public Integer campaignIsCpdPaused;
    @Parameterized.Parameter(2)
    public Integer packageIsCpd;
    @Parameterized.Parameter(3)
    public StopFlag expectedStopStatus;
    @Parameterized.Parameter(4)
    public Integer expectedIsCpdAndAutoBudgetPaidActions;

    @Parameterized.Parameters(name = "флаг это Прайсовая кампания  или нет (Кампания баннер на главной): {0}," +
            "флаг is_cpd_paused на кампании: {1}," +
            "если прайсовая: флаг на пакете is_cpd: {2}" +
            "ожидаемый статус остановки: {3}" +
            "ожидаемые флаги isCPD и AutoBudgetPaidActions: {4}"
    )
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][] {
                {true, 1, 1, StopFlag.STOP, 1},
                {true, 0, 1, StopFlag.RESUME, 1},
                {true, 0, 0, StopFlag.RESUME, null},
                {true, 1, 0, StopFlag.STOP, null},
                {false, 1, null, StopFlag.STOP, null},
                {false, 0, null, StopFlag.RESUME, null},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @After
    @Step("Утилизация тестовых данных")
    public void after() {
        api.userSteps.audienceTargetsSteps().delete(LOGIN, atId);
        api.userSteps.retargetingListsSteps().delete(LOGIN, rcId);
        api.userSteps.getDirectJooqDbSteps().pricePackagesSteps().deleteCampaignCpmPrice(packageId);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        cid = bannersRule.getCampaignId();
        Long creativeId = bannersRule.getCreativeId();
        Long bid = bannersRule.getBannerId();
        Long pid = bannersRule.getGroupId();
        Long keywordId = bannersRule.getCurrentGroup().getPhrases().get(0).getId();
        rcId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(LOGIN);
        atId = api.userSteps.audienceTargetsSteps().addWithRetargetingList(LOGIN, pid, rcId);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);

        //новые кампании всегда посылаются остановленными, поэтому выставляем orderId (кампания с orderId не новая)
        Long fakeOrderID = cid;

        CampaignsRecord campaignsRecord = jooqDbSteps.campaignsSteps().getCampaignById(cid);
        campaignsRecord.setOrderid(fakeOrderID);
        campaignsRecord.setPlatform(CampaignsPlatform.search);
        campaignsRecord.setStatusshow(CampaignsStatusshow.Yes);
        campaignsRecord.setType((isCpmPriceCampaign) ? CampaignsType.cpm_price : CampaignsType.cpm_yndx_frontpage);
        jooqDbSteps.campaignsSteps().updateCampaigns(campaignsRecord);

        jooqDbSteps.adGroupsSteps().setType(pid, PhrasesAdgroupType.cpm_yndx_frontpage);
        jooqDbSteps.adGroupsSteps().addAdGroupPriority(pid, 0);
        jooqDbSteps.bannersSteps().setBannersBannerType(bid, BannersBannerType.cpm_banner);

        if (isCpmPriceCampaign) {
            CpmPricePackagesRecord cpmPricePackagesRecord = new CpmPricePackagesRecord();
            cpmPricePackagesRecord.setPrice(BigDecimal.TEN);
            Date date = Date.valueOf(LocalDate.now());
            cpmPricePackagesRecord.setDateStart(date);
            cpmPricePackagesRecord.setDateEnd(date);
            cpmPricePackagesRecord.setIsCpd(packageIsCpd);
            packageId = jooqDbSteps.pricePackagesSteps().setCpmPricePackages(cpmPricePackagesRecord);

            jooqDbSteps.campaignsSteps().setCampaignCpmPriceStatuses(cid,
                    CampaignsCpmPriceStatusApprove.Yes, CampaignsCpmPriceStatusCorrect.Yes);
            CampaignsCpmPriceRecord campaignsCpmPrice = jooqDbSteps.campaignsSteps().getCampaignsCpmPriceById(cid);
            campaignsCpmPrice.setIsCpdPaused(campaignIsCpdPaused);
            campaignsCpmPrice.setPackageId(packageId);
            jooqDbSteps.campaignsSteps().updateCampaignCpmPrice(campaignsCpmPrice);

        } else {
            jooqDbSteps.campaignsSteps().setCampaignCpmYndxFrontpageAllowedTypes(cid, "frontpage");
            CampaignsCpmYndxFrontpageRecord campaignsCpmYndxFrontpageRecord = jooqDbSteps.campaignsSteps().getCampaignCpmYndxFrontpage(cid);
            campaignsCpmYndxFrontpageRecord.setIsCpdPaused(campaignIsCpdPaused);
            jooqDbSteps.campaignsSteps().updateCampaignCpmYndxFrontpage(campaignsCpmYndxFrontpageRecord);
        }

        jooqDbSteps.bannersPerformanceSteps()
                .setCreativeStatusModerate(cid, pid, bid, BannersPerformanceStatusmoderate.Yes);
        jooqDbSteps.perfCreativesSteps().setModerateInfo(creativeId,
                new ModerationInfo().generateTestData().toString());
        jooqDbSteps.perfCreativesSteps().setDefaultCpmPriceCampCreativeSize(creativeId);
        jooqDbSteps.perfCreativesSteps().setStatusModerate(creativeId, PerfCreativesStatusmoderate.Yes);
    }

    @Test
    public void testStopCpmPriceCampaign() {
        RunBsTransportScriptResponse resp
                = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign order =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        assertThat("проверка на правильный Order->{Stop}", order.getStop(),
                equalTo(expectedStopStatus.value()));
        assertThat("проверка на  правильный Order->{IsCPD}", order.getIsCPD(),
                equalTo(expectedIsCpdAndAutoBudgetPaidActions));
        assertThat("проверка на правильный Order->{AutobudgetPaidActions}", order.getAutobudgetPaidActions(),
                equalTo(expectedIsCpdAndAutoBudgetPaidActions));
    }
}
