package ru.yandex.autotests.directintapi.bstransport.main.cpmprice.transmit;

import java.util.Arrays;
import java.util.Collection;

import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.CreativeBannerRule;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsCpmPriceStatusApprove;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsCpmPriceStatusCorrect;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsPlatform;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusshow;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PerfCreativesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.campaigns.CampaignTypeEnum;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.displaycanvas.ModerationInfo;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Description("Проверяем отправку флага остановки кампании при отправке cpm_banner'а для cpm_price кампании")
@Features(FeatureNames.CPM_PRICE)
@Issue("https://st.yandex-team.ru/DIRECT-111712")
@RunWith(Parameterized.class)
public class SendingCpmPriceStopTest {
    private static final String LOGIN = Logins.CHECK_GOALS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static DirectCmdRule defaultClassRule = DirectCmdRule.defaultClassRule();

    public CreativeBannerRule bannersRule = new CreativeBannerRule(CampaignTypeEnum.TEXT).withUlogin(LOGIN);

    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().withRules(bannersRule);

    private static int shard;
    private Long cid;
    private Long rcId;
    private Long atId;

    @Parameterized.Parameter(0)
    public CampaignsStatusshow statusShow;
    @Parameterized.Parameter(1)
    public CampaignsCpmPriceStatusCorrect statusCorrect;
    @Parameterized.Parameter(2)
    public CampaignsCpmPriceStatusApprove statusApprove;
    @Parameterized.Parameter(3)
    public StopFlag expected;

    @Parameterized.Parameters(name = "statusShow кампании: {0}, " +
            "статус корректности кампании: {1}," +
            "статус аппрува кампании: {2}," +
            "ожидаемый статус остановки: {3}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {CampaignsStatusshow.No, CampaignsCpmPriceStatusCorrect.Yes, CampaignsCpmPriceStatusApprove.New, StopFlag.STOP},
                {CampaignsStatusshow.No, CampaignsCpmPriceStatusCorrect.Yes, CampaignsCpmPriceStatusApprove.Yes, StopFlag.STOP},
                {CampaignsStatusshow.Yes, CampaignsCpmPriceStatusCorrect.No, CampaignsCpmPriceStatusApprove.Yes, StopFlag.STOP},
                {CampaignsStatusshow.Yes, CampaignsCpmPriceStatusCorrect.Yes, CampaignsCpmPriceStatusApprove.No, StopFlag.STOP},
                {CampaignsStatusshow.Yes, CampaignsCpmPriceStatusCorrect.Yes, CampaignsCpmPriceStatusApprove.Yes, StopFlag.RESUME},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @After
    @Step("Утилизация тестовых данных")
    public void after() {
        api.userSteps.audienceTargetsSteps().delete(LOGIN, atId);
        api.userSteps.retargetingListsSteps().delete(LOGIN, rcId);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        cid = bannersRule.getCampaignId();
        Long creativeId = bannersRule.getCreativeId();
        Long bid = bannersRule.getBannerId();
        Long pid = bannersRule.getGroupId();
        Long keywordId = bannersRule.getCurrentGroup().getPhrases().get(0).getId();
        rcId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(LOGIN);
        atId = api.userSteps.audienceTargetsSteps().addWithRetargetingList(LOGIN, pid, rcId);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);

        //новые кампании всегда посылаются остановленными, поэтому выставляем orderId (кампания с orderId не новая)
        Long fakeOrderID = cid;
        jooqDbSteps.campaignsSteps().setOrderId(cid, fakeOrderID);

        jooqDbSteps.bannersPerformanceSteps()
                .setCreativeStatusModerate(cid, pid, bid, BannersPerformanceStatusmoderate.Yes);
        jooqDbSteps.perfCreativesSteps().setModerateInfo(creativeId,
                new ModerationInfo().generateTestData().toString());
        jooqDbSteps.perfCreativesSteps().setDefaultCpmPriceCampCreativeSize(creativeId);
        jooqDbSteps.perfCreativesSteps().setStatusModerate(creativeId, PerfCreativesStatusmoderate.Yes);

        jooqDbSteps.campaignsSteps().setPlatform(cid, CampaignsPlatform.search);
        jooqDbSteps.campaignsSteps().setCampaignCpmYndxFrontpageAllowedTypes(cid, "frontpage");

        jooqDbSteps.campaignsSteps().setStatusShow(cid, statusShow);

        jooqDbSteps.adGroupsSteps().setType(pid, PhrasesAdgroupType.cpm_yndx_frontpage);
        jooqDbSteps.bannersSteps().setBannersBannerType(bid, BannersBannerType.cpm_banner);
        if (statusCorrect == CampaignsCpmPriceStatusCorrect.Yes) {
            jooqDbSteps.adGroupsSteps().addAdGroupPriority(pid, 0);
        }
        jooqDbSteps.campaignsSteps().setCampaignCpmPriceStatuses(cid, statusApprove, statusCorrect);
        jooqDbSteps.campaignsSteps().setType(cid, CampaignsType.cpm_price);
    }

    @Test
    public void testStopCpmPriceCampaign() {
        RunBsTransportScriptResponse resp
                = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign order =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        assertThat("передан правильный Context->{Stop}", order.getStop(),
                equalTo(expected.value()));
    }
}
