package ru.yandex.autotests.directintapi.bstransport.main.cpmyndxfrontpage.transmit.language;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.model.bslogs.BannerLanguage;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Description("Проверяем отправку языка баннера: проставлен язык на кампании")
@Features(FeatureNames.CPM_YNDX_FRONTPAGE)
@Issue("https://st.yandex-team.ru/DIRECT-104366")
@RunWith(Parameterized.class)
public class SendingCampaignLanguageTest extends SendingLanguageBaseTest {

    @Parameterized.Parameter()
    public BannerLanguage campaignLanguage;

    @Parameterized.Parameters(name = "язык баннера: {0}")
    public static Collection<Object[]> languages() {
        Object[][] data = new Object[][]{
                {BannerLanguage.RUSSIAN},
                {BannerLanguage.ENGLISH},
                {BannerLanguage.UKRAINIAN},
                {BannerLanguage.GERMAN},
                {BannerLanguage.KAZAKH},
                {BannerLanguage.TURKISH},
                {BannerLanguage.BELARUSIAN},
                {BannerLanguage.UZBEK},
        };
        return Arrays.asList(data);
    }

    @Test
    public void sendCampaignLanguageTest() {
        setBannerLanguage("ru");
        setCampaignLanguage(campaignLanguage);

        checkLanguage(campaignLanguage.transportValue());
    }
}
