package ru.yandex.autotests.directintapi.bstransport.main.cpmyndxfrontpage.transmit.language;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Description("Проверяем отправку языка баннера: невалидные кейсы")
@Features(FeatureNames.CPM_YNDX_FRONTPAGE)
@Issue("https://st.yandex-team.ru/DIRECT-96384")
@RunWith(Parameterized.class)
public class SendingInvalidLanguageTest extends SendingLanguageBaseTest {

    @Parameterized.Parameter()
    public String bannerLanguage;

    @Parameterized.Parameters(name = "язык баннера: {0}")
    public static Collection<Object[]> languages() {
        Object[][] data = new Object[][] {
                {"Yes"},
                {"No"},
                {"unknown"},
        };
        return Arrays.asList(data);
    }

    @Test
    public void sendBannerLanguageTest() {
        setBannerLanguage(bannerLanguage);
        checkLanguage("ru");
    }
}
