package ru.yandex.autotests.directintapi.bstransport.main.dynamic.actions.creation.queue;

import java.util.Map;

import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Транспорт: проверка отправки в БК нового нацеливания")
@Stories(StoriesNames.DYNAMIC_ACTION_CREATION)
@Features({FeatureNames.DYNAMICS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class AddingToBsQueueNewDynamicTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        api.userSteps.clientFakeSteps().setAPIUnits(LOGIN, 12000000);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Test
    @Title("Отправка нового нацеливания")
    public void testNewDynamicInNewGroup() {
        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        Long bid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        runAndCheck(cid, bid, pid);
    }

    @Test
    @Title("Отправка нескольких новых нацеливаний")
    public void testSomeNewDynamicsInNewGroup() {
        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addWebpage(new WebpageAddItemMap()
                .withAdGroupId(pid)
                .withName("Name")
                .withConditions(new WebpageConditionMap()
                        .withOperand(WebpageConditionOperandEnum.PAGE_CONTENT)
                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                        .withArguments("someString")));
        api.userSteps.dynamicTextAdTargetsSteps().addWebpage(new WebpageAddItemMap()
                .withAdGroupId(pid)
                .withName("Name")
                .withConditions(new WebpageConditionMap()
                        .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                        .withArguments("someString")));
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        Long bid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        runAndCheck(cid, bid, pid);
    }

    private void runAndCheck(long cid, long bid, long pid) {
        api.userSteps.transportSteps().runBsExportMasterScript(shard, cid);
        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().runBsClientDataScript(shard, cid);

        Map campaign = api.userSteps.transportSteps().getRawClientDataLogRequestForCampaign(resp, cid);
        Map context = api.userSteps.transportSteps().getRawClientDataLogRequestForContext(resp, cid, pid);
        Map banner = api.userSteps.transportSteps().getRawClientDataLogRequestForBanner(resp, cid, pid, bid);

        assertThat("Ожидаем, что в БК была отправлена новая кампания", campaign, notNullValue());
        assertThat("Ожидаем, что в БК была отправлена новая группа", context, notNullValue());
        assertThat("Ожидаем, что в БК был отправлен новый баннер", banner, notNullValue());
    }
}
