package ru.yandex.autotests.directintapi.bstransport.main.dynamic.actions.creation.transmit;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsDynamicRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.DynamicConditionsRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Dynamic;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/TESTIRT-11509
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-67297")
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК полей нацеливания: PARAM_126 и PARAM_127")
@Stories(StoriesNames.DYNAMIC_PARAMS)
@Features({FeatureNames.DYNAMICS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportDynamicParamsTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final int PARAMS_126 = 126;
    private static final int PARAMS_127 = 127;

    private static int shard;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long dynConId;
    private static Dynamic dynamicReq;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        Long bid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        BidsDynamicRecord bidsDynamicRecord = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bidsDynamicSteps()
                .getBidsDynamicByPid(pid)
                .get(0);

        dynConId = bidsDynamicRecord.getDynCondId();

        Campaign campaignReq =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        Context contextReq = campaignReq != null ? campaignReq.getContext(pid) : null;
        dynamicReq = contextReq != null ? contextReq.getDynamic(dynConId) : null;
    }


    @Test
    public void checkDynamicParams126() {
        DynamicConditionsRecord dynamicConditions = api.userSteps.getDirectJooqDbSteps()
                .dynamicConditionsSteps()
                .getDynamicConditions(dynConId);
        assumeThat("в запросе есть нацеливание", dynamicReq.getParams(), notNullValue());
        assertThat("отправленное в БК поле PARAMS_126 соответствует ожидаемому",
                dynamicReq.getParams().get(PARAMS_126), equalTo(dynamicConditions.getConditionName()));
    }

    @Test
    public void checkDynamicParams127() {
        assumeThat("в запросе есть нацеливание", dynamicReq.getParams(), notNullValue());
        assertThat("отправленное в БК поле PARAMS_127 соответствует ожидаемому",
                dynamicReq.getParams().get(PARAMS_127), equalTo(dynConId.toString()));
    }
}
