package ru.yandex.autotests.directintapi.bstransport.main.dynamic.actions.creation.transmit;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Dynamic;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК нового нацеливания" +
        "с включенным для кампании AutobudgetNetCPCOptimize")
@Stories(StoriesNames.DYNAMIC_ACTION_CREATION)
@Features(FeatureNames.DYNAMICS)
public class BsTransportOfNewDynamicAutobudgetNetCPCOptimizeEnabledTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static Dynamic dynamicReq;
    private static Campaign campaignReq;

    @BeforeClass
    public static void beforeClass() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        api.userSteps.getDirectJooqDbSteps().useShard(shard);

        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        Long dynCondId =  api.userSteps.getDirectJooqDbSteps()
                .bidsDynamicSteps()
                .getBidsDynamicCondIdsByPid(pid)
                .get(0);
        Long bid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        api.userSteps.getDirectJooqDbSteps().campaignsSteps().enableCpcHold(cid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        campaignReq = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context contextReq = campaignReq != null ? campaignReq.getContext(pid) : null;
        dynamicReq = contextReq != null ? contextReq.getDynamic(dynCondId) : null;
    }

    @Test
    public void testTransportOfDynamicCampAutobudgetNetCPCOptimize() {
        assertThat("для динамиков AutobudgetNetCPCOptimize отправляется",
                campaignReq.getAutoBudgetNetCPCOptimize(), notNullValue());
    }

    @Test
    public void testTransportOfDynamicObjPriceContext() {
        assertThat("при отправке нацеливания с включенным для кампании " +
                        "AutobudgetNetCPCOptimize PriceContext не отправляется",
                dynamicReq.getPriceContext(), nullValue());
    }
}
