package ru.yandex.autotests.directintapi.bstransport.main.dynamic.actions.creation.transmit;

import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsDynamicRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Dynamic;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК нового нацеливания")
@Stories(StoriesNames.DYNAMIC_ACTION_CREATION)
@Features({FeatureNames.DYNAMICS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewDynamicTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long pid;
    private static Long dynId;

    private static Context contextReq1;
    private static Dynamic dynamicReq1;

    private static Context contextReq2;
    private static Collection<Dynamic> dynamicListReq2;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        BidsDynamicRecord bidsDynamicRecord = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bidsDynamicSteps()
                .getBidsDynamicByPid(pid)
                .get(0);
        dynId = bidsDynamicRecord.getDynId();
        Long dynCondId = bidsDynamicRecord.getDynCondId();
        Long bid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        Campaign campaignReq1 = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        contextReq1 = campaignReq1 != null ? campaignReq1.getContext(pid) : null;
        dynamicReq1 = contextReq1 != null ? contextReq1.getDynamic(dynCondId) : null;

        Campaign campaignReq2 = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 1, cid);
        contextReq2 = campaignReq2 != null ? campaignReq2.getContext(pid) : null;
        dynamicListReq2 = contextReq2 != null &&
                contextReq2.getDynamics() != null &&
                contextReq2.getDynamics().size() > 0 ?
                contextReq2.getDynamics().values() : null;
    }

    @Test
    @Title("Отправка в БК нового нацеливания (1 запрос) - проверка объекта Контекст")
    public void testTransportOfContextObjReq1() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленный в БК контекст соответствует ожидаемому",
                contextReq1, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК нового нацеливания (1 запрос) - проверка объекта Нацеливание")
    public void testTransportOfDynamicObjReq1() {
        Dynamic expectedDynamic = helpSteps.buildExpectedDynamicObjFromDb(dynId, shard, UpdateInfo.UPDATE);
        assertThat("отправленное в БК нацеливание соответствует ожидаемому",
                dynamicReq1, beanEquals(expectedDynamic));
    }

    @Test
    @Title("Отправка в БК нового нацеливания (2 запрос) - проверка объекта Контекст")
    public void testTransportOfContextObjReq2() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.SKIP);
        assertThat("отправленный в БК контекст соответствует ожидаемому",
                contextReq2, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК нового нацеливания (2 запрос) - проверка списка Нацеливаний")
    public void testTransportOfDynamicListReq1() {
        assertThat("в БК не отправлен список нацеливаний", dynamicListReq2, nullValue());
    }
}
