package ru.yandex.autotests.directintapi.bstransport.main.dynamic.actions.creation.transmit;

import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsDynamicRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Dynamic;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК нескольких новых нацеливаний")
@Stories(StoriesNames.DYNAMIC_ACTION_CREATION)
@Features({FeatureNames.DYNAMICS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewDynamicsTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long pid;
    private static Long dynId1;
    private static Long dynId2;

    private static Context contextReq1;
    private static Dynamic dynamic1Req1;
    private static Dynamic dynamic2Req1;

    private static Context contextReq2;
    private static Collection<Dynamic> dynamicListReq2;

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addWebpage(new WebpageAddItemMap()
                .withAdGroupId(pid)
                .withName("Name")
                .withConditions(new WebpageConditionMap()
                        .withOperand(WebpageConditionOperandEnum.PAGE_CONTENT)
                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                        .withArguments("someString")));
        api.userSteps.dynamicTextAdTargetsSteps().addWebpage(new WebpageAddItemMap()
                .withAdGroupId(pid)
                .withName("Name")
                .withConditions(new WebpageConditionMap()
                        .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                        .withArguments("someString")));
        Long bid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        List<BidsDynamicRecord> bidsDynamicRecords = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bidsDynamicSteps()
                .getBidsDynamicByPid(pid);
        dynId1 = bidsDynamicRecords.get(0).getDynId();
        dynId2 = bidsDynamicRecords.get(1).getDynId();
        Long dynCondId1 = bidsDynamicRecords.get(0).getDynCondId();
        Long dynCondId2 = bidsDynamicRecords.get(1).getDynCondId();

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        Campaign campaignReq1 = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        contextReq1 = campaignReq1 != null ? campaignReq1.getContext(pid) : null;
        dynamic1Req1 = contextReq1 != null ? contextReq1.getDynamic(dynCondId1) : null;
        dynamic2Req1 = contextReq1 != null ? contextReq1.getDynamic(dynCondId2) : null;

        Campaign campaignReq2 = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 1, cid);
        contextReq2 = campaignReq2 != null ? campaignReq2.getContext(pid) : null;
        dynamicListReq2 = contextReq2 != null &&
                contextReq2.getDynamics() != null &&
                contextReq2.getDynamics().size() > 0 ?
                contextReq2.getDynamics().values() : null;
    }

    @Test
    @Title("Отправка в БК нескольких новых нацеливаний (1 запрос) - " +
            "проверка объекта Контекст")
    public void testTransportOfContextObjReq1() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленный в БК контекст соответствует ожидаемому",
                contextReq1, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК нескольких новых нацеливаний (1 запрос) - " +
            "проверка объекта Нацеливание (1)")
    public void testTransportOfDynamicObj1Req1() {
        Dynamic expectedDynamic = helpSteps.buildExpectedDynamicObjFromDb(dynId1, shard, UpdateInfo.UPDATE);
        assertThat("отправленное в БК нацеливание соответствует ожидаемому",
                dynamic1Req1, beanEquals(expectedDynamic));
    }

    @Test
    @Title("Отправка в БК нескольких новых нацеливаний (1 запрос) - " +
            "проверка объекта Нацеливание (2)")
    public void testTransportOfDynamicObj2Req1() {
        Dynamic expectedDynamic = helpSteps.buildExpectedDynamicObjFromDb(dynId2, shard, UpdateInfo.UPDATE);
        assertThat("отправленное в БК нацеливание соответствует ожидаемому",
                dynamic2Req1, beanEquals(expectedDynamic));
    }

    @Test
    @Title("Отправка в БК нескольких новых нацеливаний в новой группе (2 запрос) - " +
            "проверка объекта Контекст")
    public void testTransportOfContextObjReq2() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.SKIP);
        assertThat("отправленный в БК контекст соответствует ожидаемому",
                contextReq2, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК нескольких новых нацеливаний в новой группе (2 запрос) - " +
            "проверка списка Нацеливаний")
    public void testTransportOfDynamicListReq1() {
        assertThat("в БК не отправлен список нацеливаний", dynamicListReq2, nullValue());
    }
}
