package ru.yandex.autotests.directintapi.bstransport.main.dynamic.actions.suspending;

import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsDynamicRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Dynamic;
import ru.yandex.autotests.directapi.enums.StatusBsSynced;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК остановки нацеливания")
@Stories(StoriesNames.DYNAMIC_ACTION_SUSPENDING)
@Features(FeatureNames.DYNAMICS)
public class BsTransportOfSuspendedDynamicTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long pid;
    private static Long dynId;

    private static Context context;
    private static Dynamic dynamic;
    private static Collection<Dynamic> dynamics;

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addWebpage(new WebpageAddItemMap()
                .withAdGroupId(pid)
                .withName("Name")
                .withConditions(new WebpageConditionMap()
                        .withOperand(WebpageConditionOperandEnum.PAGE_CONTENT)
                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                        .withArguments("someString")));
        api.userSteps.dynamicTextAdTargetsSteps().addWebpage(new WebpageAddItemMap()
                .withAdGroupId(pid)
                .withName("Name")
                .withConditions(new WebpageConditionMap()
                        .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                        .withArguments("someString")));
        Long bid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);


        List<BidsDynamicRecord> bidsDynamicRecords = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bidsDynamicSteps()
                .getBidsDynamicByPid(pid);
        dynId = bidsDynamicRecords.get(0).getDynId();
        long suspendedDynId = bidsDynamicRecords.get(1).getDynId();
        Long dynCondId = bidsDynamicRecords.get(0).getDynCondId();

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, StatusBsSynced.NO.toString());
        api.userSteps.getDirectJooqDbSteps()
                .bidsDynamicSteps()
                .setSuspended(suspendedDynId);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        dynamic = context != null ? context.getDynamic(dynCondId) : null;
        dynamics = context != null && context.getDynamics() != null ? context.getDynamics().values() : null;
    }

    @Test
    @Title("Отправка в БК остановленного нацеливания - проверка объекта Контекст")
    public void testTransportOfContextObj() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленный в БК контекст соответствует ожидаемому",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК остановленного нацеливания - проверка объекта Нацеливание (не остановленное)")
    public void testTransportOfDynamicObj() {
        Dynamic expectedDynamic = helpSteps.buildExpectedDynamicObjFromDb(dynId, shard, UpdateInfo.UPDATE);
        assertThat("отправленное в БК нацеливание соответствует ожидаемому",
                dynamic, beanEquals(expectedDynamic));
    }

    @Test
    @Title("Отправка в БК остановленного нацеливания - проверка размера списка Нацеливаний " +
            "(отсутствие остановленного нацеливания)")
    public void testTransportOfDynamicsList() {
        assertThat("отправленное в БК нацеливание соответствует ожидаемому", dynamics, hasSize(1));
    }
}
