package ru.yandex.autotests.directintapi.bstransport.main.dynamic.parameters.bid;

import java.math.BigDecimal;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsDynamicRecord;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Dynamic;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Ignore("Тест не предназначен для самостоятельного запуска.")
@RunWith(Parameterized.class)
public class BsTransportOfDynamicBidBaseTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;
    private static final float PRICE = 40.0f;

    private Dynamic dynamic;

    @Parameterized.Parameter(0)
    public DynamicTextCampaignSearchStrategyAddMap strategy;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    public void before() {
        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaignWithSearchStrategy(strategy);
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        BidsDynamicRecord bidsDynamicRecord = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN)
                .bidsDynamicSteps()
                .getBidsDynamicByPid(pid)
                .get(0);
        Long dynId = bidsDynamicRecord.getDynId();
        Long dynCondId = bidsDynamicRecord.getDynCondId();
        Long bid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        api.userSteps.getDirectJooqDbSteps().bidsDynamicSteps().setPrice(dynId, BigDecimal.valueOf(PRICE));

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        dynamic = context != null ? context.getDynamic(dynCondId) : null;

        assumeThat("в БК отправлено нацеливание", dynamic, notNullValue());
    }

    @Test
    @Title("Отправка в БК ставки на поиске для нового нацеливания (для ручных стратегий)")
    public void testTransportOfDynamicBid() {
        assertThat("отправленная в БК ставка на поиске соответствует ожидаемой",
                dynamic.getPrice(), equalTo(PRICE));
    }

    @Test
    @Title("Отправка в БК кода валюты для нового нацеливания (для ручных стратегий)")
    public void testTransportOfDynamicCurrency() {
        assertThat("отправленный в БК код валюты соответствует ожидаемому",
                dynamic.getCurrencyIsoCode(), equalTo(Currency.RUB.getIsoCode()));
    }
}
