package ru.yandex.autotests.directintapi.bstransport.main.dynamic.parameters.hidemarketrating;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Issue("https://st.yandex-team.ru/TESTIRT-12298")
@Description("Проверка отправки флага 'скрывать рейтинг Маркета' для динамических кампаний")
@RunWith(Parameterized.class)
public class BsTransportOfDynamicHideMarketRatingTest {

    private static final String LOGIN = Logins.LOGIN_MAIN;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    private int shard;
    private Long cid;

    @Parameterized.Parameter()
    public int hideMarketRatingFlag;

    @Parameterized.Parameters(name = "{index}: test with value = {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{{0}, {1}});
    }

    @Before
    @Step("создаем ДО-кампанию и сетим флаг hide_market_rating")
    public void createCampaign() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();

        api.userSteps.getDirectJooqDbSteps().useShard(shard).clientsOptionsSteps()
                .setHideMarketRating(Long.valueOf(User.get(LOGIN).getClientID()), hideMarketRatingFlag);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
    }

    @Test
    public void checkQueue() {
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps()
                .sendNewCampaign(shard, cid);

        Campaign order = api.userSteps.transportSteps().getClientDataRequestCampaign(resp, cid);

        assertThat("для ДО-кампании отправлено поле HideMarketRating",
                order.getHideMarketRating(), notNullValue());
        assertThat("для ДО-кампании отправлено поле HideMarketRating c правильным значением",
                order.getHideMarketRating(), equalTo(hideMarketRatingFlag));
    }
}
