package ru.yandex.autotests.directintapi.bstransport.main.dynamic.parameters.priority;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsDynamicRecord;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.AutoBudgetPriority;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Dynamic;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК приоритета нацеливания для автоматических стратегий на поиске")
@Stories(StoriesNames.DYNAMIC_PARAMS_PRIORITY)
@Features(FeatureNames.DYNAMICS)
@RunWith(Parameterized.class)
public class BsTransportOfDynamicPriorityForSearchStrategiesTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;
    private static long goalId;

    @Parameterized.Parameter(0)
    public DynamicTextCampaignSearchStrategyMap searchStrategy;

    @Parameterized.Parameter(1)
    public AutoBudgetPriority priority;

    @Parameterized.Parameters(name = "Стратегия на поиске = {0}, приоритет = {1}")
    public static Collection<Object[]> data() {
        goalId = MetrikaGoals.getGoalForLogin(LOGIN);
        Object[][] data = new Object[][]{
                {
                        new DynamicTextCampaignSearchStrategyMap().defaultWbMaximumClicks(Currency.RUB),
                        AutoBudgetPriority.LOW
                },
                {
                        new DynamicTextCampaignSearchStrategyMap().defaultWbMaximumClicks(Currency.RUB),
                        AutoBudgetPriority.MEDIUM
                },
                {
                        new DynamicTextCampaignSearchStrategyMap().defaultWbMaximumClicks(Currency.RUB),
                        AutoBudgetPriority.HIGH
                },
                {
                        new DynamicTextCampaignSearchStrategyMap().defaultAverageCpa(Currency.RUB, goalId),
                        AutoBudgetPriority.LOW
                },
                {
                        new DynamicTextCampaignSearchStrategyMap().defaultAverageCpc(Currency.RUB),
                        AutoBudgetPriority.HIGH
                },
                {
                        new DynamicTextCampaignSearchStrategyMap().defaultAverageCpa(Currency.RUB, goalId),
                        AutoBudgetPriority.HIGH
                }
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Test
    @Title("Отправка в БК приоритета нацеливания для автоматических стратегий на поиске")
    public void testTransportOfDynamicPriority() {
        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .addCampMetrikaGoals(cid, goalId, 100L, 100L);
        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap()
                .withCampaigns(new CampaignUpdateItemMap()
                        .withId(cid)
                        .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                                .withBiddingStrategy(new DynamicTextCampaignStrategyMap()
                                        .withSearch(searchStrategy)))));
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        BidsDynamicRecord bidsDynamicRecord = api.userSteps.getDirectJooqDbSteps()
                .bidsDynamicSteps()
                .getBidsDynamicByPid(pid)
                .get(0);
        Long dynId = bidsDynamicRecord.getDynId();
        Long dynCondId = bidsDynamicRecord.getDynCondId();
        Long bid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        api.userSteps.getDirectJooqDbSteps()
                .bidsDynamicSteps()
                .setAutobudgetPriority(dynId, Integer.parseInt(priority.transportValue()));

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        Dynamic dynamic = context != null ? context.getDynamic(dynCondId) : null;

        assumeThat("в БК отправлено нацеливание", dynamic, notNullValue());
        assertThat("отправленный в БК приоритет нацеливания соответствует ожидаемому",
                dynamic.getAutoBudgetPriority(), equalTo(priority.transportValue()));
    }
}
