package ru.yandex.autotests.directintapi.bstransport.main.dynbanner.actions.creation.queue;

import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BsExportQueueRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.matchers.QueueRecordMatcher;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.junit.Assert.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Транспорт: проверка постановки в очередь ppc.bs_export_queue " +
        "нового дин. баннера в синхронизированной группе")
@Stories(StoriesNames.DYN_BANNER_ACTION_CREATION)
@Features({FeatureNames.DYN_BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class AddingToBsQueueNewDynBannerInSyncedGroupTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    @Title("Добавление в очередь нового динамического баннера в синхронизированной группе")
    public void testAddingToBsQueue() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        Long bid1 = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);
        Long bid2 = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid1);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid2);

        // выставляем баннеру статус statusPostModerate = No, чтобы он не отправился
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusPostModerate(bid1, Status.NO);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, Status.NO);
        // выставляем баннеру положительный статус модерации
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusPostModerate(bid1, Status.YES);

        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);
        BsExportQueueRecord exportQueueRecord =
                api.userSteps.getDarkSideSteps().getDirectJooqDbSteps(shard).transportSteps().getBsExportQueueRecord(cid);
        assertThat("статистика в очереди соответствует ожидаемой",
                exportQueueRecord, new QueueRecordMatcher()
                        .withoutCamps()
                        .withContexts()
                        .withBanners()
                        .withBids());
    }
}
