package ru.yandex.autotests.directintapi.bstransport.main.dynbanner.actions.creation.queue;

import java.util.Map;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BsExportQueueRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.directintapi.bstransport.matchers.QueueRecordMatcher;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Транспорт: проверка постановки в очередь ppc.bs_export_queue " +
        "нового отклоненного дин. баннера в составе синхронизированной группы")
@Stories(StoriesNames.DYN_BANNER_ACTION_CREATION)
@Features({FeatureNames.DYN_BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class AddingToBsQueueNewDynBannerInSyncedGroupWithNegativeModerationTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private Long cid;
    private Long pid;
    private Long bid1;
    private Long bid2;

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().setAPIUnits(LOGIN, 12000000);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    public void prepare() {
        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        bid1 = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);
        bid2 = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid1);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid2);

        // выставляем баннеру статус statusPostModerate = No, чтобы он не отправился
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusPostModerate(bid1, Status.NO);
        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
    }

    /*
        Здесь проверяется, что в очередь попадает группа с отклоненным новым баннером
        и отсутствием других рассинхронизированных объектов
     */
    @Test
    @Title("Добавление в очередь кампании с новым отклоненным дин. баннером " +
            "в синхронизированной группе (статус группы statusBsSynced = No)")
    public void testAddingToBsQueueWithUnsyncedGroup() {
        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, Status.NO);

        api.userSteps.transportSteps().runBsExportMasterScript(shard, cid);
        BsExportQueueRecord campInExportQueue =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).transportSteps().getBsExportQueueRecord(cid);
        assertThat("в таблице ppc.bs_export_queue присутствует правильная запись",
                campInExportQueue,
                new QueueRecordMatcher()
                        .withoutCamps()
                        .withBanners()
                        .withContexts()
                        .withBids()
                        .withoutPrices());
        RunBsTransportScriptResponse resp = api.userSteps.transportSteps().runBsClientDataScript(shard, cid);
        Map campaign = api.userSteps.transportSteps().getRawClientDataLogRequestForCampaign(resp, cid);
        Map context = api.userSteps.transportSteps().getRawClientDataLogRequestForContext(resp, cid, pid);
        Map banner1 = api.userSteps.transportSteps().getRawClientDataLogRequestForBanner(resp, cid, pid, bid1);
        Map banner2 = api.userSteps.transportSteps().getRawClientDataLogRequestForBanner(resp, cid, pid, bid2);

        assertThat("Ожидаем, что в БК может быть отправлена кампания", campaign, notNullValue());
        assertThat("Ожидаем, что в БК может была отправлена группа", context, notNullValue());
        assertThat("Ожидаем, что в БК не отправлен баннер с PostModerate = NO", banner1, nullValue());
        assertThat("Ожидаем, что в БК может быть отправлен баннер", banner2, notNullValue());

        Campaign campaignReq = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp,
                0, cid);
        Context contextReq = campaignReq != null ? campaignReq.getContext(pid) : null;
        Banner bannerReq = context != null ? contextReq.getBanner(bid2) : null;

        Banner expectedBanner = helpSteps.buildExpectedBannerObjFromDb(bid2, shard, UpdateInfo.SKIP);
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                bannerReq, beanEquals(expectedBanner));
    }

    /*
        Здесь проверяется, что после того, как группа отправится без отклоненного баннера,
        новая итерация bsExportMaster не добавит отклоненный баннер в очередь
     */
    @Test
    @Title("Добавление в очередь кампании с новым отклоненным дин. баннером " +
            "в синхронизированной группе (статус группы statusBsSynced = Yes)")
    public void testAddingToBsQueueWithSyncedGroup() {
        // состояние после отправки группы после сброса ее статуса statusBsSynced (DIRECT-33440)
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, Status.YES);

        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);
        BsExportQueueRecord exportQueueRecord =
                api.userSteps.getDarkSideSteps().getDirectJooqDbSteps(shard).transportSteps().getBsExportQueueRecord(cid);
        assertThat("в таблице ppc.bs_export_queue присутствует запись только для группы " +
                "со сброшенным статусом синхронизации после модерации баннера", exportQueueRecord, nullValue());
    }
}
