package ru.yandex.autotests.directintapi.bstransport.main.dynbanner.actions.creation.queue;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Проверяются только статусы, соответствующие непромодерированным баннерам
 * (статус Yes проверяется в тесте AddingToBsQueueNewDynBannerInSyncedGroupTest)
 * (статус No проверяется в тесте AddingToBsQueueNewDynBannerInSyncedGroupWithNegativeModerationTest)
 */
@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Транспорт: проверка не-постановки в очередь ppc.bs_export_queue " +
        "нового непромодерированного дин. баннера в составе синхронизированной группы")
@Stories(StoriesNames.DYN_BANNER_ACTION_CREATION)
@Features({FeatureNames.DYN_BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class AddingToBsQueueNewDynBannerInSyncedGroupWithNoModerationTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter
    public String testStatus;

    @Parameterized.Parameters(name = "Статус statusPostModerate = {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {Status.NEW},
                {Status.READY},
                {Status.SENT}
                // rejected - не проверяем, так как для нового баннера это не актуально
        };
        return Arrays.asList(data);
    }

    @Test
    @Title("Не-постановка в очередь кампании с новым непромодерированным дин. баннером " +
            "в синхронизированной ранее группе")
    public void testAddingToBsQueue() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        Long bid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);
        Long bidElse = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidElse);

        // выставляем баннеру статус statusPostModerate = NEW, чтобы он не отправился
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusPostModerate(bid, Status.NEW);
        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusPostModerate(bid, testStatus);

        api.userSteps.transportSteps().runBsExportMasterScript(shard, cid);
        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().runBsClientDataScript(shard, cid);

        Map campaign = api.userSteps.transportSteps().getRawClientDataLogRequestForCampaign(resp, cid);
        Map context = api.userSteps.transportSteps().getRawClientDataLogRequestForContext(resp, cid, pid);
        Map banner = api.userSteps.transportSteps().getRawClientDataLogRequestForBanner(resp, cid, pid, bid);

        assertThat("Ожидаем, что в БК не была отправлена новая кампания", campaign, nullValue());
        assertThat("Ожидаем, что в БК не была отправлена новая группа", context, nullValue());
        assertThat("Ожидаем, что в БК не был отправлен новый баннер", banner, nullValue());
    }
}
