package ru.yandex.autotests.directintapi.bstransport.main.dynbanner.actions.creation.receive;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.isEmptyOrNullString;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка изменений после отправки в БК нового дин. баннера в новой кампании")
@Stories(StoriesNames.DYN_BANNER_ACTION_CREATION)
@Features({FeatureNames.DYN_BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsResponseHandlingForNewDynBannerInNewCampaignTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    private static Long cid;
    private static Long pid;
    private static Long bid;

    private static Campaign campaign;
    private static Banner banner;

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().setAPIUnits(LOGIN, 12000000);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        api.userSteps.getDirectJooqDbSteps().useShard(shard);

        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        bid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataResponseCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        banner = context != null ? context.getBanner(bid) : null;
    }

    @Test
    @Title("Изменения после отправки в БК нового дин. баннера в новой кампании - " +
            "statusBsSynced Кампании")
    public void testCampaignSyncStatus() {
        CampaignsRecord campaignDb = api.userSteps.getDirectJooqDbSteps().campaignsSteps().getCampaignById(cid);
        assertThat("после синхронизации статус кампании statusBsSynced = Yes",
                campaignDb.getStatusbssynced(), equalTo(CampaignsStatusbssynced.Yes));
    }

    @Test
    @Title("Изменения после отправки в БК нового дин. баннера в новой кампании - " +
            "statusBsSynced Контекста")
    public void testGroupSyncStatus() {
        PhrasesRecord groupDb = api.userSteps.getDirectJooqDbSteps().adGroupsSteps().getPhrases(pid);
        assertThat("после синхронизации статус группы statusBsSynced = Yes",
                groupDb.getStatusbssynced(), equalTo(PhrasesStatusbssynced.Yes));
    }

    @Test
    @Title("Изменения после отправки в БК нового дин. баннера в новой кампании - " +
            "statusBsSynced Баннера")
    public void testDynBannerSyncStatus() {
        BannersRecord bannerDb = api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().getBanner(bid);
        assertThat("после синхронизации статус баннера statusBsSynced = Yes",
                bannerDb.getStatusbssynced(), equalTo(BannersStatusbssynced.Yes));
    }

    @Test
    @Title("Изменения после отправки в БК нового дин. баннера в новой кампании - " +
            "OrderID Кампании")
    public void testCampaignOrderId() {
        assumeThat("в ответе БК присутствует кампания", campaign, notNullValue());
        String orderId = campaign.getId();
        assumeThat("БК прислал в ответе OrderID", orderId, not(isEmptyOrNullString()));

        CampaignsRecord campaignDb = api.userSteps.getDirectJooqDbSteps().campaignsSteps().getCampaignById(cid);
        assertThat("после синхронизации кампании выставлен правильный OrderID",
                campaignDb.getOrderid().toString(), equalTo(orderId));
    }

    @Test
    @Title("Изменения после отправки в БК нового дин. баннера в новой кампании - " +
            "BannerID Баннера")
    public void testDynBannerBannerId() {
        assumeThat("в ответе БК присутствует баннер", banner, notNullValue());
        String bannerId = banner.getId();
        assumeThat("БК прислал в ответе BannerID", bannerId, not(isEmptyOrNullString()));

        BannersRecord bannerDb = api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().getBanner(bid);
        assertThat("после синхронизации баннеру выставлен правильный BannerID",
                bannerDb.getBannerid().toString(), equalTo(bannerId));
    }
}
