package ru.yandex.autotests.directintapi.bstransport.main.dynbanner.actions.creation.transmit.moderation;

import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Sitelink;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/*
    Здесь проверяем, что баннер с принятыми сайтлинками отправляется с сайтлинками
    (при этом баннер без контактов и отправляется независимо от отрицательного статуса их модерации)
 */
@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК нового дин. баннера " +
        "с принятыми сайтлинками в новой группе")
@Stories(StoriesNames.DYN_BANNER_ACTION_CREATION)
@Features({FeatureNames.DYN_BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewDynBannerInNewGroupWithAcceptedLinksTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final Integer SITELINKS_SET_SIZE = 3;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long bid;
    private static Long pid;

    private static Context context;
    private static Banner banner;
    private static List<Sitelink> sitelinks;

    @BeforeClass
    public static void prepare() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        Long sitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(SITELINKS_SET_SIZE);
        bid = api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withDynamicTextAd(new DynamicTextAdAddMap()
                                .defaultDynamicTextAd()
                                .withSitelinkSetId(sitelinkSetId)
                        )
                        .withAdGroupId(pid)
        );

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusModerate(bid, Status.YES);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setPhoneflag(bid, Status.NEW);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusSitelinksModerate(bid, Status.YES);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusPostModerate(bid, Status.YES);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp,
                cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        banner = context != null ? context.getBanner(bid) : null;
        sitelinks = banner != null ? banner.getSitelinks() : null;
    }

    @Test
    @Title("Отправка в БК нового дин. баннера с принятыми сайтлинками в новой группе " +
            "- проверка объекта Контекст")
    public void testTransportOfContext() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные новой группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК нового дин. баннера с принятыми сайтлинками в новой группе " +
            "- проверка объекта Баннер")
    public void testTransportOfBanner() {
        Banner expectedBanner = helpSteps.buildExpectedNewBannerObjFromDb(bid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                banner, beanEquals(expectedBanner));
    }

    @Test
    @Title("Отправка в БК нового дин. баннера с принятыми сайтлинками в новой группе " +
            "- проверка наличия сайтлинков")
    public void testTransportOfSitelinks() {
        assertThat("сайтлинки отправлены в БК", sitelinks, hasSize(SITELINKS_SET_SIZE));
    }
}
