package ru.yandex.autotests.directintapi.bstransport.main.dynbanner.actions.creation.transmit.moderation;

import java.util.List;
import java.util.Map;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runners.Parameterized;

import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.directintapi.bstransport.TransportTestUtils;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Ignore("Тест не предназначен для самостоятельного запуска.")
public class BsTransportOfNewDynBannerInNewGroupWithNegativeModerationBaseTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    @Parameterized.Parameter
    public String testStatus;

    private Long acceptedBid;
    private Long pid;

    private Context context;
    private Banner acceptedBanner;
    private List<Banner> bannerList;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    public void prepare() {
        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        acceptedBid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);
        Long notAcceptedBid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(acceptedBid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(notAcceptedBid);

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusModerate(notAcceptedBid, Status.YES);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setPhoneflag(notAcceptedBid, Status.NEW);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusSitelinksModerate(notAcceptedBid, Status.NEW);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusPostModerate(notAcceptedBid, testStatus);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        Map<String, Banner> banners = context != null ? context.getBanners() : null;
        bannerList = TransportTestUtils.getMapValues(banners);
        acceptedBanner = context != null ? context.getBanner(acceptedBid) : null;
    }

    @Test
    @Title("Не-отправка в БК не принятого нового дин. баннера в новой группе - " +
            "проверка объекта Контекст")
    public void testTransportOfContext() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Не-отправка в БК не принятого нового дин. баннера в новой группе - " +
            "проверка количества Баннеров (что отправлен только принятый баннер)")
    public void testTransportOfBannerList() {
        assertThat("в БК отправлен список баннеров правильного размера",
                bannerList, hasSize(1));
    }

    @Test
    @Title("Не-отправка в БК не принятого нового дин. баннера в новой группе - " +
            "проверка объекта Баннер (принятый)")
    public void testTransportOfAcceptedBanner() {
        Banner expectedAcceptedBanner = helpSteps.buildExpectedNewBannerObjFromDb(acceptedBid, shard,
                UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные принятого баннера соответствуют ожидаемым",
                acceptedBanner, beanEquals(expectedAcceptedBanner));
    }
}
