package ru.yandex.autotests.directintapi.bstransport.main.dynbanner.actions.creation.transmit.moderation;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runners.Parameterized;

import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ContactInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/*
    Здесь проверяем, что с любым отрицательным статусом модерации визитки
    баннер отправляется, но без нее
 */
@Ignore("Тест не предназначен для самостоятельного запуска.")
public class BsTransportOfNewDynBannerInNewGroupWithNotAcceptedContactsBaseTest {

    protected static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    protected static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    @Parameterized.Parameter
    public String testStatus;

    protected Long bid;
    protected Long pid;

    protected Campaign campaign;
    protected Context context;
    protected Banner banner;
    protected ContactInfo contactInfo;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    public void prepare() {
        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        Long vCardId = api.userSteps.vCardsSteps().addDefaultVCard(cid);
        bid = api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withDynamicTextAd(new DynamicTextAdAddMap()
                                .defaultDynamicTextAd()
                                .withVCardId(vCardId)
                        )
                        .withAdGroupId(pid)
        );

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusModerate(bid, Status.YES);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setPhoneflag(bid, testStatus);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusSitelinksModerate(bid, Status.NEW);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusPostModerate(bid, Status.YES);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        banner = context != null ? context.getBanner(bid) : null;
        contactInfo = banner != null ? banner.getContactInfo() : null;
    }

    @Test
    @Title("Отправка в БК кампании с новым дин. баннером в новой группе " +
            "с не принятой визиткой - проверка объекта Контекст")
    public void testTransportOfContext() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные новой группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК кампании с новым дин. баннером в новой группе " +
            "с не принятой визиткой - проверка объекта Баннер")
    public void testTransportOfBanner() {
        Banner expectedBanner = helpSteps.buildExpectedNewBannerObjFromDb(bid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                banner, beanEquals(expectedBanner));
    }

    @Test
    @Title("Отправка в БК кампании с новым дин. баннером в новой группе " +
            "с не принятой визиткой - проверка отсутствия Визитки")
    public void testTransportOfVcard() {
        assertThat("визитка не отправлена в БК", contactInfo, nullValue());
    }
}
