package ru.yandex.autotests.directintapi.bstransport.main.dynbanner.actions.creation.transmit.moderation;

import java.util.List;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runners.Parameterized;

import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.directintapi.bstransport.TransportTestUtils;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/*
    Здесь проверяем, что баннер с непромодерированными сайтлинками не отправляется
 */
public class BsTransportOfNewDynBannerInNewGroupWithNotModeratedLinksBaseTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    @Parameterized.Parameter
    public String testStatus;

    private Long acceptedBid;
    private Long pid;

    private Context context;
    private Banner banner;
    private List<Banner> banners;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    public void prepare() {
        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        acceptedBid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);
        Long sitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(1);
        Long testBid = api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withDynamicTextAd(new DynamicTextAdAddMap()
                                .defaultDynamicTextAd()
                                .withSitelinkSetId(sitelinkSetId)
                        )
                        .withAdGroupId(pid)
        );

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().makeBannerFullyModerated(acceptedBid);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().makeBannerFullyModerated(testBid);

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusModerate(testBid, Status.YES);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setPhoneflag(testBid, Status.NEW);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusSitelinksModerate(testBid, testStatus);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusPostModerate(testBid, Status.YES);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        banners = TransportTestUtils.getMapValues(context != null ? context.getBanners() : null);
        banner = context != null ? context.getBanner(acceptedBid) : null;
    }

    @Test
    @Title("Не-отправка в БК нового дин. баннера с непромодерированными сайтлинками " +
            "в новой группе - проверка объекта Контекст")
    public void testTransportOfContext() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные новой группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Не-отправка в БК нового дин. баннера с непромодерированными сайтлинками " +
            "в новой группе - проверка объекта Баннер (принятый)")
    public void testTransportOfBanner() {
        Banner expectedBanner = helpSteps.buildExpectedNewBannerObjFromDb(acceptedBid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                banner, beanEquals(expectedBanner));
    }

    @Test
    @Title("Не-отправка в БК нового дин. баннера с непромодерированными сайтлинками " +
            "в новой группе - проверка количества баннеров (что отправлен только принятый баннер)")
    public void testTransportOfBannerList() {
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                banners, hasSize(1));
    }
}
