package ru.yandex.autotests.directintapi.bstransport.main.dynbanner.actions.creation.transmit.moderation;
import ru.yandex.qatools.Tag;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;

import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import java.util.Arrays;
import java.util.Collection;

/*
    Здесь проверяем, что баннер с непромодерированными сайтлинками не отправляется
 */
@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка не-отправки в БК нового дин. баннера " +
        "с непромодерированными сайтлинками в составе новой группы (1)")
@Stories(StoriesNames.DYN_BANNER_ACTION_CREATION)
@Features({FeatureNames.DYN_BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class BsTransportOfNewDynBannerInNewGroupWithNotModeratedLinksTest1
        extends BsTransportOfNewDynBannerInNewGroupWithNotModeratedLinksBaseTest {

    @Parameterized.Parameters(name = "Статус statusSitelinksModerate = {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][] {
                {Status.NEW},
                {Status.READY}
        };
        return Arrays.asList(data);
    }
}
