package ru.yandex.autotests.directintapi.bstransport.main.dynbanner.actions.creation.transmit.moderation;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК нескольких новых дин. баннеров в новой группе")
@Stories(StoriesNames.DYN_BANNER_ACTION_CREATION)
@Features({FeatureNames.DYN_BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewDynBannersInNewGroupTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long bid1;
    private static Long bid2;
    private static Long pid;

    private static Context context;
    private static Banner banner1;
    private static Banner banner2;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        bid1 = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);
        bid2 = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid1);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid2);

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusModerate(bid1, Status.YES);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setPhoneflag(bid1, Status.NEW);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusSitelinksModerate(bid1, Status.NEW);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusPostModerate(bid1, Status.YES);

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusModerate(bid2, Status.YES);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setPhoneflag(bid2, Status.NEW);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusSitelinksModerate(bid2, Status.NEW);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusPostModerate(bid2, Status.YES);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        banner1 = context != null ? context.getBanner(bid1) : null;
        banner2 = context != null ? context.getBanner(bid2) : null;
    }

    @Test
    @Title("Отправка в БК кампании с новыми дин. баннерами в новой группе " +
            "- проверка объекта Контекст")
    public void testTransportOfContext() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные новой группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК кампании с новыми дин. баннерами в новой группе " +
            "- проверка объекта Баннер (1)")
    public void testTransportOfBanner1() {
        Banner expectedBanner = helpSteps.buildExpectedNewBannerObjFromDb(bid1, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                banner1, beanEquals(expectedBanner));
    }

    @Test
    @Title("Отправка в БК кампании с новыми дин. баннерами в новой группе " +
            "- проверка объекта Баннер (2)")
    public void testTransportOfBanner2() {
        Banner expectedBanner = helpSteps.buildExpectedNewBannerObjFromDb(bid2, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                banner2, beanEquals(expectedBanner));
    }
}
