package ru.yandex.autotests.directintapi.bstransport.main.dynbanner.actions.creation.transmit.req1;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsDynamicRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.BannerTemplateId;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Dynamic;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК нового дин. баннера " +
        "в новой кампании (1 запрос)")
@Stories(StoriesNames.DYN_BANNER_ACTION_CREATION)
@Features({FeatureNames.DYN_BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewDynBannerInNewCampaignTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long cid;
    private static Long pid;
    private static Long dynId;
    private static Long bid;
    private static Long bidWithContactInfo;
    private static Long pidWithTargetingOnCity;
    private static Long bidWithGeoFlag;

    private static Campaign campaign;
    private static Context context;
    private static Banner banner;
    private static Dynamic dynamic;


    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        bid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        BidsDynamicRecord bidsDynamicRecord = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bidsDynamicSteps()
                .getBidsDynamicByPid(pid)
                .get(0);
        dynId = bidsDynamicRecord.getDynId();
        Long dynCondId = bidsDynamicRecord.getDynCondId();

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        banner = context != null ? context.getBanner(bid) : null;
        dynamic = context != null ? context.getDynamic(dynCondId) : null;
    }

    @Test
    @Title("1я итерация: Отправка в БК новой кампании с дин. баннером -" +
            "проверка объекта ORDER")
    public void testTransportOfCampaignReq1() {
        assertThat("отправленные в БК данные новой кампании соответствуют ожидаемым",
                campaign, helpSteps.campaignReq1Matcher(cid, shard));
    }

    @Test
    @Title("1я итерация: Отправка в БК новой кампании с дин. баннером - " +
            "проверка объекта CONTEXT")
    public void testTransportOfContextReq1() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные новой группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("1я итерация: Отправка в БК новой кампании с дин. баннером - " +
            "проверка объекта DYNAMIC")
    public void testTransportOfDynamicReq1() {
        Dynamic expectedDynamic = helpSteps.buildExpectedDynamicObjFromDb(dynId, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные нового нацеливания соответствуют ожидаемым",
                dynamic, beanEquals(expectedDynamic));
    }

    @Test
    @Title("1я итерация: Отправка в БК новой кампании с дин. баннером - " +
            "проверка объекта BANNER")
    @Description("Провреяем параметры Stop, TemplateID")
    public void testTransportOfBannerReq1() {
        Banner expectedBanner = helpSteps.buildExpectedNewBannerObjFromDb(bid, shard, UpdateInfo.UPDATE);
        expectedBanner.setTemplateId(BannerTemplateId.PPC_TEMPLATE_ID.value());
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                banner, beanEquals(expectedBanner));
    }


}
