package ru.yandex.autotests.directintapi.bstransport.main.dynbanner.actions.creation.transmit.req1;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsDynamicRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Dynamic;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК нового дин. баннера " +
        "в синхронизированной кампании (1 запрос)")
@Stories(StoriesNames.DYN_BANNER_ACTION_CREATION)
@Features({FeatureNames.DYN_BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewDynBannerInSyncedCampaignTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long cid;
    private static Long pid;
    private static Long dynId;
    private static Long newBid;
    private static Long syncedBid;

    private static Campaign campaign;
    private static Context context;
    private static Banner newBanner;
    private static Banner syncedBanner;
    private static Dynamic dynamic;


    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        syncedBid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);
        newBid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(syncedBid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(newBid);

        BidsDynamicRecord bidsDynamicRecord = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bidsDynamicSteps()
                .getBidsDynamicByPid(pid)
                .get(0);
        dynId = bidsDynamicRecord.getDynId();
        Long dynCondId = bidsDynamicRecord.getDynCondId();

        // выставляем баннеру статус statusPostModerate = No, чтобы он не отправился
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusPostModerate(newBid, Status.NO);
        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, Status.NO);
        // выставляем баннеру положительный статус модерации
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusPostModerate(newBid, Status.YES);


        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        syncedBanner = context != null ? context.getBanner(syncedBid) : null;
        newBanner = context != null ? context.getBanner(newBid) : null;
        dynamic = context != null ? context.getDynamic(dynCondId) : null;
    }


    @Test
    @Title("Отправка в БК нового дин. баннера в синхронизированной кампании (1 запрос) - " +
            "проверка объекта Кампания")
    public void testTransportOfCampaignReq1() {
        Campaign expectedCampaign = helpSteps.buildExpectedCampaignObjFromDb(cid.intValue(), shard, UpdateInfo.SKIP);
        assertThat("отправленные в БК данные кампании соответствуют ожидаемым",
                campaign, beanEquals(expectedCampaign));
    }

    @Test
    @Title("Отправка в БК нового дин. баннера в синхронизированной кампании (1 запрос) - " +
            "проверка объекта Контекст")
    public void testTransportOfContextReq1() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК нового дин. баннера в синхронизированной кампании (1 запрос) - " +
            "проверка объекта Нацеливание")
    public void testTransportOfDynamicReq1() {
        Dynamic expectedDynamic = helpSteps.buildExpectedDynamicObjFromDb(dynId, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные нацеливания соответствуют ожидаемым",
                dynamic, beanEquals(expectedDynamic));
    }

    @Test
    @Title("Отправка в БК нового дин. баннера в синхронизированной кампании (1 запрос) - " +
            "проверка объекта Баннер (синхронизированный)")
    public void testTransportOfSyncedBannerReq1() {
        Banner expectedBanner = helpSteps.buildExpectedBannerObjFromDb(syncedBid, shard, UpdateInfo.SKIP);
        expectedBanner.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                syncedBanner, beanEquals(expectedBanner));
    }

    @Test
    @Title("Отправка в БК нового дин. баннера в синхронизированной кампании (1 запрос) - " +
            "проверка объекта Баннер (новый)")
    public void testTransportOfNewBanner() {
        Banner expectedBanner = helpSteps.buildExpectedNewBannerObjFromDb(newBid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                newBanner, beanEquals(expectedBanner));
    }
}
