package ru.yandex.autotests.directintapi.bstransport.main.dynbanner.actions.creation.transmit.req2;

import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.BannerTemplateId;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.tags.BsTransportParameters;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.DynamicTextAdGroupMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.model.common.RegionIDValues;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasItem;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.directapi.darkside.steps.TransportSteps.getBsClientDataBanner;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;


/**
 * Created by pashkus on 23/01/17.
 * https://st.yandex-team.ru/TESTIRT-10837
 */

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Tag(BsTransportParameters.TemplateID)
@Title("Транспорт: проверка отправки в БК TemplateID для нового дин.баннера")
@Stories(StoriesNames.DYN_BANNER_ACTION_CREATION)
@Features({FeatureNames.DYN_BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BannerTemplateIdForNewCampaignWithDynamicTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long cid;
    private static Long pid;
    private static Long bid;
    private static Long bidWithContactInfo;
    private static Long pidWithTargetingOnCity;
    private static Long bidWithGeoFlag;

    private static Campaign campaignReq1;
    private static RunBsTransportScriptResponse resp;


    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        bid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        Long vCardId = api.userSteps.vCardsSteps().addDefaultVCard(cid);
        bidWithContactInfo = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withDynamicTextAd(new DynamicTextAdAddMap()
                        .defaultDynamicTextAd()
                        .withVCardId(vCardId)));

        //группа с узким гео-таргетингом (banners.opts <- geoflag)
        pidWithTargetingOnCity = api.userSteps.adGroupsSteps().addGroup(
                new AdGroupAddItemMap().defaultAdGroupAddItem(cid)
                        .withDynamicTextAdGroup(new DynamicTextAdGroupMap().defaultGroup())
                        .withRegionIds(Long.parseLong(RegionIDValues.SPB_ID)));
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pidWithTargetingOnCity);
        bidWithGeoFlag = api.userSteps.adsSteps().addDefaultDynamicTextAd(pidWithTargetingOnCity);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidWithContactInfo);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pidWithTargetingOnCity);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidWithGeoFlag);

        resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        campaignReq1 = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
    }


    @Test
    @Title("1я итерация: проверка TemplateID для динамического баннера со стандартным шаблоном")
    public void testDynBannerTemplateID320Req1() {
        Banner banner = getBsClientDataBanner(campaignReq1,pid,bid);
        assertThat("TemplateID баннера соотв. ожиданиям",
                banner.getTemplateId(), equalTo(BannerTemplateId.PPC_TEMPLATE_ID.value()));
    }

    @Test
    @Title("1я итерация: проверка TemplateID для динамического баннера с ContactInfo")
    public void testDynBannerTemplateID410Req1() {
        Banner banner = getBsClientDataBanner(campaignReq1,pid,bidWithContactInfo);
        assertThat("TemplateID баннера соотв. ожиданиям",
                banner.getTemplateId(), equalTo(BannerTemplateId.PPC_TEMPLATE_ID_NEW.value()));
    }

    @Test
    @Title("1я итерация: проверка TemplateID для динамического баннера с GeoFlag")
    public void testDynBannerTemplateID269Req1() {
        Banner banner = getBsClientDataBanner(campaignReq1,pidWithTargetingOnCity, bidWithGeoFlag);
        assertThat("TemplateID баннера соотв. ожиданиям",
                banner.getTemplateId(), equalTo(BannerTemplateId.PPC_TEMPLATE_ID_GEO.value()));
    }

    @Test
    @Title("2я итерация: отправка динамического баннера со стандартным шаблоном")
    @Description("Ожидаем, что при UpdateInfo=0 параметр TempateID не будет отправлен")
    public void testDynBannerTemplateId320Req2() {
        Map<String, Map> banner = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getRawClientDataLogRequestForBanner(resp, cid, pid, bid, 1);
        assertThat("ключ TemplateID отсутсвует в баннере",
                banner.keySet(), not(hasItem("TemplateID")));
    }

    @Test
    @Title("2я итерация: отправка динамического баннера с ContactInfo")
    @Description("Ожидаем, что при UpdateInfo=0 параметр TempateID не будет отправлен")
    public void testDynBannerTemplateId410Req2() {
        Map<String, Map> banner = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getRawClientDataLogRequestForBanner(resp, cid, pid, bidWithContactInfo, 1);
        assertThat("ключ TemplateID отсутсвует в баннере",
                banner.keySet(), not(hasItem("TemplateID")));
    }

    @Test
    @Title("2я итерация: отправка динамического баннера с GeoFlag")
    @Description("Ожидаем, что при UpdateInfo=0 параметр TempateID не будет отправлен")
    public void testDynBannerTemplateId269Req2() {
        Map<String, Map> banner = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getRawClientDataLogRequestForBanner(resp, cid, pidWithTargetingOnCity, bidWithGeoFlag, 1);
        assertThat("ключ TemplateID отсутсвует в баннере",
                banner.keySet(), not(hasItem("TemplateID")));
    }
}
