package ru.yandex.autotests.directintapi.bstransport.main.dynbanner.actions.creation.transmit.req2;

import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Dynamic;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.isEmptyOrNullString;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК нового дин. баннера " +
        "в новой остановленной кампании (2 запрос)")
@Stories(StoriesNames.DYN_BANNER_ACTION_CREATION)
@Features({FeatureNames.DYN_BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewDynBannerInNewStoppedCampaignTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long cid;
    private static Long pid;
    private static Long bid;

    private static Campaign campaignResp1;
    private static Banner bannerResp1;

    private static Campaign campaignReq2;
    private static Context contextReq2;
    private static Collection<Dynamic> dynamicsReq2;
    private static Banner bannerReq2;


    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        bid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        api.userSteps.campaignSteps().campaignsSuspend(cid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        campaignResp1 = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataResponseCampaign(resp, 0, cid);
        Context contextResp1 = campaignResp1 != null ? campaignResp1.getContext(pid) : null;
        bannerResp1 = contextResp1 != null ? contextResp1.getBanner(bid) : null;

        campaignReq2 = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 1, cid);
        contextReq2 = campaignReq2 != null ? campaignReq2.getContext(pid) : null;
        bannerReq2 = contextReq2 != null ? contextReq2.getBanner(bid) : null;
        dynamicsReq2 = contextReq2 != null &&
                contextReq2.getDynamics() != null &&
                contextReq2.getDynamics().values().size() > 0 ?
                contextReq2.getDynamics().values() : null;
    }

    @Test
    @Title("Отправка в БК нового дин. баннера в новой остановленной кампании (2 запрос) - " +
            "проверка объекта Кампания")
    public void testTransportOfCampaignReq2() {
        String orderId = campaignResp1.getId();
        assumeThat("БК вернула OrderId", orderId, not(isEmptyOrNullString()));

        Campaign expectedCampaign = helpSteps.buildExpectedCampaignObjFromDb(cid, shard, UpdateInfo.SKIP);
        expectedCampaign.setId(orderId);
        expectedCampaign.setStop(StopFlag.STOP.value());
        assertThat("отправленные в БК данные новой кампании соответствуют ожидаемым",
                campaignReq2, beanEquals(expectedCampaign));
    }

    @Test
    @Title("Отправка в БК нового дин. баннера в новой остановленной кампании (2 запрос) - " +
            "проверка объекта Контекст")
    public void testTransportOfContextReq2() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.SKIP);
        assertThat("отправленные в БК данные новой группы соответствуют ожидаемым",
                contextReq2, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК нового дин. баннера в новой остановленной кампании (2 запрос) - " +
            "проверка списка Нацеливаний")
    public void testTransportOfDynamicsListReq2() {
        assertThat("вторым запросом не отправлены нацеливания", dynamicsReq2, nullValue());
    }

    @Test
    @Title("Отправка в БК нового дин. баннера в новой остановленной кампании (2 запрос) - " +
            "проверка объекта Баннер")
    public void testTransportOfBannerReq2() {
        String bannerId = bannerResp1.getId();
        assumeThat("БК вернула BannerID в ответе на первый запрос",
                bannerId, not(isEmptyOrNullString()));

        Banner expectedBanner = helpSteps.buildExpectedBannerObjFromDb(bid, shard, UpdateInfo.SKIP);
        expectedBanner.setId(bannerId);
        expectedBanner.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                bannerReq2, beanEquals(expectedBanner));
    }
}
