package ru.yandex.autotests.directintapi.bstransport.main.dynbanner.actions.edition;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsDynamicRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ContactInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Dynamic;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК дин. баннера с визиткой без сайтлинков")
@Stories(StoriesNames.DYN_BANNER_ACTION_EDITION)
@Features({FeatureNames.DYN_BANNERS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfDynBannerWithContactsAndNoLinksTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long pid;
    private static Long dynId;
    private static Long bid;

    private static Context context;
    private static Dynamic dynamic;
    private static Banner banner;
    private static ContactInfo contactInfo;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        Long vCardId = api.userSteps.vCardsSteps().addDefaultVCard(cid);
        bid = api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withDynamicTextAd(new DynamicTextAdAddMap()
                                .defaultDynamicTextAd()
                                .withVCardId(vCardId)
                        )
                        .withAdGroupId(pid)
        );

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setPhoneflag(bid, Status.YES);

        BidsDynamicRecord bidsDynamicRecord = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bidsDynamicSteps()
                .getBidsDynamicByPid(pid)
                .get(0);
        dynId = bidsDynamicRecord.getDynId();
        Long dynCondId = bidsDynamicRecord.getDynCondId();
        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);


        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusBsSynced(bid, Status.NO);
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, Status.NO);


        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        dynamic = context != null ? context.getDynamic(dynCondId) : null;
        banner = context != null ? context.getBanner(bid) : null;
        contactInfo = banner != null ? banner.getContactInfo() : null;
    }

    @Test
    @Title("Отправка в БК дин. баннера c визиткой без сайтлинков - " +
            "проверка объекта Контекст")
    public void testTransportOfContext() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные новой группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК дин. баннера c визиткой без сайтлинков - " +
            "проверка объекта Нацеливание")
    public void testTransportOfDynamic() {
        Dynamic expectedDynamic = helpSteps.buildExpectedDynamicObjFromDb(dynId, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные нового нацеливания соответствуют ожидаемым",
                dynamic, beanEquals(expectedDynamic));
    }

    @Test
    @Title("Отправка в БК дин. баннера c визиткой без сайтлинков - " +
            "проверка объекта Баннер")
    public void testTransportOfBanner() {
        Banner expectedBanner = helpSteps.buildExpectedBannerObjFromDb(bid, shard, UpdateInfo.UPDATE);
        expectedBanner.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                banner, beanEquals(expectedBanner));
    }

    @Test
    @Title("Отправка в БК дин. баннера c визиткой без сайтлинков - " +
            "проверка наличия Визитки")
    public void testTransportOfContacts() {
        assertThat("в БК отправлена визитка", contactInfo, notNullValue());
    }
}
