package ru.yandex.autotests.directintapi.bstransport.main.dynbanner.parameters.bannerland;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.BannerLandDataDynamic;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.Matchers.isEmptyString;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * created by pashkus on 17.10.2016
 * https://st.yandex-team.ru/TESTIRT-10250
 */

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-57500")
@Title("Проверка отправки в БК BannerLandData.СampaignMinusWords для минус-фраз дин. баннера c UpdateInfo=1")
@Stories(StoriesNames.DYN_BANNER_PARAMS_BANNERLAND)
@Features(FeatureNames.DYN_BANNERS)
@RunWith(Parameterized.class)
public class BsTransportOfBannerLandDataCampaignMinusPhrasesTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private final String FAKE_MINUSWORD = "workaround3";  //Todo: using it until api will apply minus phrases.

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(0)
    public String[] campaignMinusWords;

    @Parameterized.Parameter(1)
    public String expectedCampaignMinusWords;

    private Banner banner;

    @Parameterized.Parameters(name = "ожидаем в BannerLandData.CampaignMinusWords={1}")
    public static Collection<Object[]> data() {
        return Arrays.asList(
                new Object[] {new String[]{"минус фраза"}, "(минус фраза)"},
                new Object[] {new String[]{"минусслово1", "минус фраза", "минусслово2"}, "минусслово1 (минус фраза) минусслово2"},
                new Object[] {new String[]{"минус фраза1", "минус фраза2"}, "(минус фраза1) (минус фраза2)"},
                new Object[] {new String[]{"минус фраза1", "минусслово", "минус фраза2" }, "(минус фраза1) минусслово (минус фраза2)"}
        );
    }

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Step("Предусловия: создаем кампанию с минус-фразами в camp_options")
    @Before
    public void before() {
        Long cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withNegativeKeywords(FAKE_MINUSWORD)
                .withDefaultDynamicTextCampaign());
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .setCampOptionsMinusWords(cid, JsonUtils.toString(campaignMinusWords, true));
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        Long bid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        banner = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid).getContext(pid).getBanner(bid);
    }

    @Test
    @Title("Проверяем поле BannerLandData.CampaignMinusWords для дин. баннера")
    @Description("Ожидаем, что минус фразы CampaignMinusWords будут обособленны скобками: (минус фраза)")
    public void testBannerLandDataCampaignMinusWords() {
        assumeThat("в БК отправлен баннер", banner, notNullValue());
        assumeThat("UpdateInfo отправленного баннера " + UpdateInfo.UPDATE
                , banner.getUpdateInfo(), equalTo(UpdateInfo.UPDATE.value()));
        assumeThat("отправленное поле BannerLandData не пустое", banner.getBannerLandData(), not(isEmptyString()));

        String bannerLand = banner.getBannerLandData().replaceAll("\\\\", "");
        BannerLandDataDynamic bannerLandDataDynamic = JsonUtils.getObject(bannerLand, BannerLandDataDynamic.class);

        assertThat("отправленное в БК поле BannerLandData.СampaignMinusWords соответствуют ожиданиям",
                bannerLandDataDynamic.getCampaignMinusWords(), equalTo(expectedCampaignMinusWords));
    }
}
