package ru.yandex.autotests.directintapi.bstransport.main.dynbanner.parameters.bannerland;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import com.google.gson.Gson;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersMinusGeoType;
import ru.yandex.autotests.direct.utils.model.RegionIDValues;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.BannerLandDataDynamic;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.DynamicTextAdGroupMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.google.common.base.Joiner.on;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.hamcrest.Matchers.isEmptyString;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by n-boy on 09.03.2017
 * https://st.yandex-team.ru/TESTIRT-11106
 */

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-63267")
@Title("Транспорт: проверка отправки в БК BannerLandData для дин. баннера c UpdateInfo=1, поле Geo, с учетом минус-регионов")
@Stories(StoriesNames.MINUS_GEO)
@Features(FeatureNames.DYN_BANNERS)
@RunWith(Parameterized.class)
public class BsTransportOfBannerLandDataGeoWithMinusGeoTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;
    private Banner banner;

    private static List adgroupGeo = Arrays.asList(String.valueOf(RegionIDValues.RUSSIA.getId()), String.valueOf(RegionIDValues.UKRAINE.getId()));

    @Parameterized.Parameter(0)
    public List<String> bannerCurrentMinusGeo;

    @Parameterized.Parameter(1)
    public List<String> resBannerLandGeo;

    @Parameterized.Parameters()
    public static Collection<Object[]> data() {
        return Arrays.asList(
                new Object[]{Arrays.asList(String.valueOf(RegionIDValues.RUSSIA.getId())),
                        Arrays.asList(String.valueOf(RegionIDValues.UKRAINE.getId()))},
                new Object[]{adgroupGeo,
                        Arrays.asList(String.valueOf(RegionIDValues.BS_MOON.getId()))}
        );
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Step("Подготовка данных для теста")
    @Before
    public void before() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addGroup(new AdGroupAddItemMap()
                .defaultAdGroupAddItem(cid)
                .withDynamicTextAdGroup(new DynamicTextAdGroupMap()
                        .defaultGroup()));
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().updatePhrases(
                api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps()
                        .getPhrases(pid)
                        .setGeo(on(',').join(adgroupGeo))
        );
        Long bid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().saveBannersMinusGeo(
                bid, BannersMinusGeoType.current, StringUtils.join(bannerCurrentMinusGeo, ",")
        );

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        banner = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid).getContext(pid).getBanner(bid);

        assumeThat("в БК отправлен баннер", banner, notNullValue());
    }

    @Test
    @Title("Отправка в БК BannerLandData для дин. баннера, проверяем Geo")
    public void testBannerLandData() {
        assumeThat("отправленное поле BannerLandData не пустое", banner.getBannerLandData(), not(isEmptyString()));

        BannerLandDataDynamic bannerLandDataDynamic = new Gson().fromJson(banner.getBannerLandData()
                , BannerLandDataDynamic.class);

        String[] bl_geo = bannerLandDataDynamic.getGeo().equals("")
                                ? new String[]{}
                                : bannerLandDataDynamic.getGeo().split(",");

        assertThat("отправленное в БК поле BannerLandData.Geo соответствуют ожидаемому",
                Arrays.asList(bl_geo),
                containsInAnyOrder(resBannerLandGeo.stream().map(s -> Matchers.equalTo(s)).collect(Collectors.toList())));
    }
}
