package ru.yandex.autotests.directintapi.bstransport.main.dynbanner.parameters.bannerland;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.GroupParamsRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.darkside.model.HrefOpeningParams;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.BannerLandDataDynamic;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.Matchers.isEmptyString;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-42105")
@Title("Транспорт: проверка отправки в БК BannerLandData для дин. баннера. Поле HrefParams, раскрытие")
@Stories(StoriesNames.DYN_BANNER_PARAMS_BANNERLAND)
@Features(FeatureNames.DYN_BANNERS)
public class BsTransportOfBannerLandDataHrefParamsOpenningTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    private Banner banner;
    private String hrefParams;
    private Long cid;
    private Long pid;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Step("Подготовка данных для теста")
    @Before
    public void before() {
        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        Long bid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        hrefParams = String
                .format("value={%s}&value1={%s}&value2={%s}&value3={%s}&value4={%s}&value5={%s}"
                        , HrefOpeningParams.CAMPAIGN_ID
                        , HrefOpeningParams.ADGROUP_ID
                        , HrefOpeningParams.CAMPAIGNID
                        , HrefOpeningParams.ADGROUPID
                        , HrefOpeningParams.CAMPAIGN_TYPE
                        , HrefOpeningParams.CAMPAIGNTYPE);
        GroupParamsRecord groupParams = new GroupParamsRecord()
                .setPid(pid)
                .setHasPhraseidHref(1)
                .setHrefParams(hrefParams);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().saveGroupParams(groupParams);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        banner = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid).getContext(pid).getBanner(bid);
    }

    @Test
    @Title("Отправка в БК BannerLandData для дин. баннера")
    public void testBannerLandData() {
        assumeThat("в БК отправлен баннер", banner, notNullValue());
        assumeThat("UpdateInfo отправленного баннера " + UpdateInfo.UPDATE
                , banner.getUpdateInfo(), equalTo(UpdateInfo.UPDATE.value()));
        assumeThat("отправленное поле BannerLandData не пустое", banner.getBannerLandData(), not(isEmptyString()));

        String bannerLand = banner.getBannerLandData().replaceAll("\\\\", "");
        BannerLandDataDynamic bannerLandData = JsonUtils.getObject(bannerLand, BannerLandDataDynamic.class);
        assertThat("отправленное в БК поле BannerLandData.HrefParams соответствуют ожидаемому",
                bannerLandData.getHrefParams(), equalTo(hrefParams
                        .replace(HrefOpeningParams.CAMPAIGN_ID.getParamName(), cid.toString())
                        .replace(HrefOpeningParams.ADGROUP_ID.getParamName(), pid.toString())
                        .replace(HrefOpeningParams.CAMPAIGNID.getParamName(), cid.toString())
                        .replace(HrefOpeningParams.ADGROUPID.getParamName(), pid.toString())
                        .replace(HrefOpeningParams.CAMPAIGN_TYPE.getParamName(), CampaignsType.DYNAMIC.type())
                        .replace(HrefOpeningParams.CAMPAIGNTYPE.getParamName(), CampaignsType.DYNAMIC.type())
                        .replaceAll("\\{", "")
                        .replaceAll("\\}", "")));
    }
}
